import java.util.*;

 import org.trinitydesktop.qt.*;
 import org.trinitydesktop.koala.*;

 /**
 *  Class to text KComboBox widgets.
 *
 *  This is a translation to java from kcomboboxtest.cpp in the tests library
 *  of tdeui source.
 *
 *    Combo boxes tested
 *      - Editable ComboBox
 *      - Select Only ComboBox
   * @see KComboBox
   * @see TDEApplication
   * @see TDEConfig
   *
   * @author original author unknown, java translation Kenneth J. Pouncey,
 kjpou@hotmail.com
   * @version 0.1
   */
 public class KComboBoxTest {

    static String description = "Java KComboBox test program.";
    static String[][] options = {   };
    static String VERSION = "0.1";

    public static void main(String[] cmdLineArgs) {

       TDEAboutData aboutData = new TDEAboutData( "kcomboboxtest", "KComboBoxTest",
          VERSION, description, TDEAboutData.License_GPL,
          "(c) 2002, Kenneth J. Pouncey");
       aboutData.addAuthor("Kenneth J. Pouncey",null, "kjpou@hotmail.com");
       TDECmdLineArgs.init( cmdLineArgs, aboutData );
       TDECmdLineArgs.addCmdLineOptions( options ); // Add our own options.

       TDEApplication app = new TDEApplication();

       // parse the args
       TDECmdLineArgs args = TDECmdLineArgs.parsedArgs();

       // Make a central widget to contain the other widgets
       TQWidget w = new TQWidget();
       // Insert the widget container (parent widget) into
       // a layout manager (VERTICAL).
       TQVBoxLayout vbox = new TQVBoxLayout( w, KDialog.marginHint(),
 KDialog.spacingHint() );
       // Resize the widget
       w.resize( 500, 100 );

       String[] list = {"Stone" , "Tree" , "Pebbles" , "Ocean" , "Sand" , "Chips"
 , "Computer" , "Mankind"};

       // Create and modify read-write widget
       KComboBox rwc = new KComboBox( true, w, "rwcombobox" );
       TQLabel lblrw = new TQLabel( rwc, "&Editable ComboBox", w, "rwcombolabel",0
 );
       rwc.setDuplicatesEnabled( true );
       rwc.completionObject().setItems( list );
       rwc.setInsertionPolicy( TQComboBox.NoInsertion );
       rwc.insertStringList( list );
       rwc.setEditText( "KDE Java Bindings" );

       // Create a read-write combobox and reproduce konqueror's code
       KComboBox konqc = new KComboBox( true, w, "konqc" );
       konqc.setMaxCount( 10 );
       TDESimpleConfig historyConfig = new TDESimpleConfig("konq_history");
       historyConfig.setGroup( "Location Bar" );
       TDECompletion s_pCompletion = new TDECompletion();
       s_pCompletion.setOrder( TDECompletion.Weighted );

       String[] rle = null;
 //      historyConfig.readListEntry( "ComboContents" ,rle);
       s_pCompletion.setItems( rle );
       s_pCompletion.setCompletionMode( TDEGlobalSettings.completionMode() );
       konqc.setCompletionObject( s_pCompletion );

       TQLabel lblkonq = new TQLabel( konqc, "&Konqueror's ComboBox", w );
 //      konqc.insertItem( TDEIconLoader.SmallIcon("www"),
 //                         "http://www.kde.org" );
       konqc.insertItem( app.iconLoader().loadIcon("www",0 ),
                          "http://www.kde.org" );
       konqc.setCurrentItem( konqc.count()-1 );

       // Create a read-only widget
       KComboBox soc = new KComboBox( w, "socombobox" );
       TQLabel lblso = new TQLabel( soc, "&Select-Only ComboBox", w, "socombolabel",0 );
       soc.setCompletionMode( TDEGlobalSettings.CompletionAuto );
       soc.completionObject().setItems( list );
       soc.insertStringList( list );

       // Create an exit button
       TQPushButton push = new TQPushButton( "E&xit", w );

       TQObject.connect( push, Qt.TQ_SIGNAL("clicked()"), app, Qt.TQ_SLOT("closeAllWindows()" ) );

       // Insert the widgets into the layout manager.
       vbox.addWidget( lblrw );
       vbox.addWidget( rwc );
       vbox.addWidget( lblso );
       vbox.addWidget( soc );
       vbox.addWidget( lblkonq );
       vbox.addWidget( konqc );
       vbox.addWidget( push );

       app.setMainWidget(w);
       rwc.setFocus();
       w.show();

       app.exec();
       return;
    }

         static {
			qtjava.initialize();
			tdejava.initialize();
         }

 }


