/***************************************************************************
* $Id$
**
* Custom MIME type implementation example
**
* Created : 979899
**
* Copyright (C) 1997 by Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/
import org.trinitydesktop.qt.*;


class SecretDrag extends TQStoredDrag {

//create the object withe the secret byte
public SecretDrag( byte secret, TQWidget  parent, String  name )
{
    super( "secret/magic", parent, name );
    byte[] data = { 0 };
    data[0]= secret;
    setEncodedData( data );
}

public SecretDrag( byte secret, TQWidget  parent )
{
	this(secret, parent, null);
}


public static boolean canDecode( TQDragMoveEvent e )
{
    return e.provides( "secret/magic" );
}

//decode it into a string
public static boolean decode( TQDropEvent e, StringBuffer str )
{
    byte[] payload = e.data( "secret/magic" );
    if ( payload.length > 0 ) {
	e.accept();
	String msg = "The secret number is " + payload[0];
	str.setLength(0);
	str.append(msg);
	return true;
    }
    return false;
}

}
