


#include <tqcstring.h>
#include <tqimage.h>
#include <tqpainter.h>
#include <tqpalette.h>
#include <tqpixmap.h>
#include <tqfont.h>

#include <kjs/object.h>

#include <kjsembed/global.h>
#include <kjsembed/jsobjectproxy.h>
#include <kjsembed/jsopaqueproxy.h>
#include <kjsembed/jsbinding.h>

#include <tqcanvas.h>
#include "qcanvaspolygon_imp.h"

/**
 * Namespace containing the KJSEmbed library.
 */
namespace KJSEmbed {

TQCanvasPolygonImp::TQCanvasPolygonImp( KJS::ExecState *exec, int mid, bool constructor )
   : JSProxyImp(exec), id(mid), cons(constructor)
{
}

TQCanvasPolygonImp::~TQCanvasPolygonImp()
{
}

/**
 * Adds bindings for static methods and enum constants to the specified Object.
 */
void TQCanvasPolygonImp::addStaticBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

	{ 0, 0 }
    };

    int idx = 0;
    TQCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            TQCanvasPolygonImp *meth = new TQCanvasPolygonImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }


}

/**
 * Adds bindings for instance methods to the specified Object.
 */
void TQCanvasPolygonImp::addBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

        { Method_setPoints_3, "setPoints" },
        { Method_points_4, "points" },
        { Method_moveBy_5, "moveBy" },
        { Method_areaPoints_6, "areaPoints" },
        { Method_rtti_7, "rtti" },
	{ 0, 0 }
    };

    int idx = 0;
    TQCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            TQCanvasPolygonImp *meth = new TQCanvasPolygonImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }
}

/**
 * Extract a TQCanvasPolygon pointer from an Object.
 */
TQCanvasPolygon *TQCanvasPolygonImp::toTQCanvasPolygon( KJS::Object &self )
{
    JSObjectProxy *ob = JSProxy::toObjectProxy( self.imp() );
    if ( ob ) {
        TQObject *obj = ob->object();
	if ( obj )
           return dynamic_cast<TQCanvasPolygon *>( obj );
    }

    JSOpaqueProxy *op = JSProxy::toOpaqueProxy( self.imp() );
    if ( !op )
        return 0;

    if ( op->typeName() != "TQCanvasPolygon" )
        return 0;

    return op->toNative<TQCanvasPolygon>();
}

/**
 * Select and invoke the correct constructor.
 */
KJS::Object TQCanvasPolygonImp::construct( KJS::ExecState *exec, const KJS::List &args )
{
   switch( id ) {

         case Constructor_QCanvasPolygon_1:
             return TQCanvasPolygon_1( exec, args );
             break;

         default:
             break;
    }

    TQString msg = i18n("TQCanvasPolygonCons has no constructor with id '%1',").arg(id);
    return throwError(exec, msg,KJS::ReferenceError);
}


KJS::Object TQCanvasPolygonImp::TQCanvasPolygon_1( KJS::ExecState *exec, const KJS::List &args )
{

    // Unsupported parameter TQCanvas *
    return KJS::Object();

    TQCanvas * arg0; // Dummy


    // We should now create an instance of the TQCanvasPolygon object

    TQCanvasPolygon *ret = new TQCanvasPolygon(

          arg0 );


}

KJS::Value TQCanvasPolygonImp::call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args )
{
    instance = TQCanvasPolygonImp::toTQCanvasPolygon( self );

    switch( id ) {

    case Method_setPoints_3:
        return setPoints_3( exec, self, args );
        break;

    case Method_points_4:
        return points_4( exec, self, args );
        break;

    case Method_moveBy_5:
        return moveBy_5( exec, self, args );
        break;

    case Method_areaPoints_6:
        return areaPoints_6( exec, self, args );
        break;

    case Method_rtti_7:
        return rtti_7( exec, self, args );
        break;

    default:
        break;
    }

    TQString msg = i18n( "TQCanvasPolygonImp has no method with id '%1'." ).arg( id );
    return throwError(exec, msg,KJS::ReferenceError);
}


KJS::Value TQCanvasPolygonImp::setPoints_3( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    // Unsupported parameter TQPointArray
    return KJS::Value();

    TQPointArray arg0; // Dummy

      instance->setPoints(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasPolygonImp::points_4( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      instance->points(  );
      return KJS::Value(); // Returns 'TQPointArray'

}

KJS::Value TQCanvasPolygonImp::moveBy_5( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    double arg0 = extractDouble(exec, args, 0);

    double arg1 = extractDouble(exec, args, 1);

      instance->moveBy(
       arg0,
       arg1 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasPolygonImp::areaPoints_6( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      instance->areaPoints(  );
      return KJS::Value(); // Returns 'TQPointArray'

}

KJS::Value TQCanvasPolygonImp::rtti_7( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      int ret;
      ret = instance->rtti(  );
      return KJS::Number( ret );

}


} // namespace KJSEmbed
