/***************************************************************************
 *   Copyright (C) 2004 by Richard Moore                                   *
 *   rich@kde.org                                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

# include "global.h"

#ifdef QT_ONLY
# include <tqobject.h>
# include <cstdio>
# ifdef _WIN32
#  include <windows.h>
#  include <fcntl.h>
#  include <io.h>
#  include <iostream.h>
#  include <tqfile.h>
# endif
#endif

static TQTextStream *kjsembed_err = 0L;
static TQTextStream *kjsembed_in = 0L;
static TQTextStream *kjsembed_out = 0L;

#ifndef _WIN32
char *itoa(int num, char *str, int radix)
{
   int k;
   char c, flag, *ostr;

   if (num < 0) {
      num = -num;
      *str++ = '-';
   }
   k = 10000;
   ostr = str;
   flag = 0;
   while (k) {
      c = num / k;
      if (c || k == 1 || flag) {
         num %= k;
         c += '0';
         *str++ = c;
         flag = 1;
      }
      k /= 10;
   }
   *str = '\0';
   return ostr;
}

#endif

#ifdef _WIN32
static TQFile win32_stdin;
static TQFile win32_stdout;
static TQFile win32_stderr;

static const WORD MAX_CONSOLE_LINES = 500;

void RedirectIOToConsole() {
   int hConHandle;
   long lStdHandle;
   CONSOLE_SCREEN_BUFFER_INFO coninfo;
   AllocConsole(); 
   GetConsoleScreenBufferInfo(GetStdHandle(STD_OUTPUT_HANDLE), &coninfo);
   coninfo.dwSize.Y = MAX_CONSOLE_LINES;
   SetConsoleScreenBufferSize(GetStdHandle(STD_OUTPUT_HANDLE), coninfo.dwSize);
   
   lStdHandle = (long)GetStdHandle(STD_INPUT_HANDLE);
   hConHandle = _open_osfhandle(lStdHandle, _O_TEXT);
   win32_stdin.open(IO_ReadOnly,hConHandle);

   lStdHandle = (long)GetStdHandle(STD_OUTPUT_HANDLE);
   hConHandle = _open_osfhandle(lStdHandle, _O_TEXT);
   win32_stdout.open(IO_WriteOnly,hConHandle );

   lStdHandle = (long)GetStdHandle(STD_ERROR_HANDLE);
   hConHandle = _open_osfhandle(lStdHandle, _O_TEXT);
   win32_stderr.open(IO_WriteOnly,hConHandle);

   ios::sync_with_stdio();

}



#endif


TQTextStream &consoleOut(  )
{
   return *KJSEmbed::conout();
}

TQTextStream &consoleError( )
{
   return *KJSEmbed::conerr();
}

TQTextStream &consoleIn( )
{
   return *KJSEmbed::conin();
}

#ifdef QT_ONLY
TQTextStream &kdDebug( int area )
{
#ifndef QT_DEBUG
   return consoleError() << "DEBUG: (" << area << ") ";
#else
   return consoleOut();
#endif

}

TQTextStream &kdWarning( int area )
{
   return consoleOut() << "WARNING: (" << area << ") ";
}

TQString i18n( const char *string )
{
	return TQObject::tr( string, "qjsembed string");
}

#endif

TQTextStream *KJSEmbed::conin()
{
   if ( !kjsembed_in ) {
#ifdef _WIN32
	   kjsembed_in = new TQTextStream( &win32_stdin );
#else
	   kjsembed_in = new TQTextStream( stdin, IO_ReadOnly );
#endif
   }
   return kjsembed_in;
}

TQTextStream *KJSEmbed::conout()
{
   if ( !kjsembed_out ) {
#ifdef _WIN32
	   kjsembed_out = new TQTextStream( &win32_stdout  );
#else
	   kjsembed_out = new TQTextStream( stdout, IO_WriteOnly );
#endif
   }
   return kjsembed_out;

}

TQTextStream *KJSEmbed::conerr()
{
   if ( !kjsembed_err ) {
#ifdef _WIN32
	   kjsembed_err = new TQTextStream( &win32_stderr  );
#else
	   kjsembed_err = new TQTextStream( stderr, IO_WriteOnly );
#endif
   }
   return kjsembed_err;
}
