#!/usr/bin/env kjscmd

//
// Setup main window
//
mw = new TDEMainWindow();
ac = mw.actionCollection();
mb = mw.menuBar();
sb = mw.statusBar();
mw.setStandardToolBarMenuEnabled( true );

view = new TQScrollView( mw, 'view' );

lbl = new TQLabel( view, 'view' );
lbl.alignment = Qt.AlignCenter;
lbl.text = 'No Content';

view.addChild( lbl );

mw.setCentralWidget( view );

///////////////////////////////////////////////////////////////////////////////////////

//
// Center the image in the view
//
mw.update_layout = function()
{
    var x = 0;
    var y = 0;

    if ( lbl.width < view.width )
	x = Math.floor( (view.width - lbl.width) / 2 );
    if ( lbl.height < view.height )
	y = Math.floor( (view.height - lbl.height) / 2 );

    view.addChild( lbl, x, y );
}

mw.resizeEvent = function(ev)
{
    this.update_layout();
}

mw.update_view = function()
{
    lbl.pixmap = this.img.pixmap();

    lbl.adjustSize();
    this.update_layout();
}

//
// Load the specified image
//
mw.load = function( filename )
{
    if ( /^\w+:/.test( filename ) )
        filename = filename.replace( /^\w+:/, '' );

    this.img = new Image();	
    this.img.load( filename );
	
    if ( !this.img.isOk() ) {
	throw 'Failed to load image ' + filename;
    }
    
    sb.message( filename );
    this.imgfile = filename;
    this.update_view();
}

//
// Save the specified image
//
mw.save = function( filename )
{
    var ok = this.img.save( filename );
	
    if ( !ok ) {
	throw 'Failed to save image ' + filename;
    }
}

//
// Open an image file.
//
mw.openFile = function()
{
    var filename = StdDialog.getOpenFileName( '.' );

    if ( filename.length > 0 ) {
	this.load( filename );
	openrecent_action.addURL( filename );
	openrecent_action.saveEntries( System.KJSConfig.tdeconfig(), 'test' );
	System.KJSConfig.sync();
    }
}

//
// Save an image file.
//
mw.saveFile = function()
{
    this.save( this.imgfile );
}

//
// Save an image file.
//
mw.saveFileAs = function()
{
    var filename = StdDialog.getSaveFileName( '.' );

    if ( filename.length > 0 ) {
	if ( this.save( filename ) ) {
	    sb.message( filename );
	    this.imgfile = filename;
	    openrecent_action.addURL( filename );
	    openrecent_action.saveEntries( System.KJSConfig.tdeconfig(), 'test' );
	    System.KJSConfig.sync();
	}
    }
}

mw.saveCopyAs = function()
{
    var filename = StdDialog.getSaveFileName( '.' );

    if ( filename.length > 0 ) {
	this.save( filename );
    }
}

mw.fileProperties = function()
{
    var net = new NetAccess( null, 'net' );
    net.propertiesDialog( 'file:' + this.imgfile );
}

mw.run_ksnapshot = function()
{
    shell( 'ksnapshot' );
}

//
// Setup the actions
//
mw.setup_actions = function()
{
    // File menu
    open_action = StdAction.open( null, '', ac );
    open_action.connect( open_action, 'activated()', this, 'openFile' );

    openrecent_action = StdAction.openRecent( null, '', ac );
    openrecent_action.connect( openrecent_action, 'urlSelected(const KURL&)', this, 'load' );
    openrecent_action.loadEntries( System.KJSConfig.tdeconfig(), 'test' );

    save_action = StdAction.save( null, '', ac );
    save_action.connect( save_action, 'activated()', this, 'saveFile' );

    saveas_action = StdAction.saveAs( null, '', ac );
    saveas_action.connect( saveas_action, 'activated()', this, 'saveFileAs' );

    savecopyas_action = new TDEAction( ac, 'save_copy_as_action' );
    savecopyas_action.text = 'Save Copy As...';
    savecopyas_action.icon = 'filesaveas';
    savecopyas_action.connect( savecopyas_action, 'activated()', this, 'saveCopyAs' );

    fileproperties_action = new TDEAction( ac, 'file_properties_action' );
    fileproperties_action.text = 'Properties...';
    fileproperties_action.connect( fileproperties_action, 'activated()', this, 'fileProperties' );

    StdAction.quit( application, 'quit()', ac );

    // View menu
//     StdAction.fitToPage( null, '', ac );
//     StdAction.fitToWidth( null, '', ac );
//     StdAction.fitToHeight( null, '', ac );
//     StdAction.actualSize( null, '', ac );

//     StdAction.zoomIn( null, '', ac );
//     StdAction.zoomOut( null, '', ac );
//     StdAction.zoom( null, '', ac );

//     StdAction.redisplay( null, '', ac );

    // Effects
    browseeffects_action = new TDEAction( ac, 'browseeffects_action' );
    browseeffects_action.text = 'Browse Effects...';
    browseeffects_action.shortcut = 'Ctrl+E';
    browseeffects_action.connect( browseeffects_action, 'activated()', this, 'browse_effects' );

    this.create_effect_browser();
    this.create_all_effects( mw, ac );
    this.create_image_operations( mw, ac );

    // Tools
    ksnapshot_action = new TDEAction( ac, 'ksnapshot_action' );
    ksnapshot_action.text = 'KSnapshot';
    ksnapshot_action.icon = 'ksnapshot';
    ksnapshot_action.connect( ksnapshot_action, 'activated()', this, 'run_ksnapshot' );

    scriptconsole_action = new TDEToggleAction( ac, 'scriptconsole_action' );
    scriptconsole_action.text = 'Script Console';
    scriptconsole_action.icon = 'konsole';
    scriptconsole_action.connect( scriptconsole_action, 'toggled(bool)', part.view(), 'setShown(bool)' );

    // Settings
    showmenubar_action = StdAction.showMenubar( null, '', ac );
    showmenubar_action.connect( showmenubar_action, 'toggled(bool)', mb, 'setShown(bool)' );

    showstatusbar_action = StdAction.showStatusbar( null, '', ac );
    showstatusbar_action.connect( showstatusbar_action, 'toggled(bool)', sb, 'setShown(bool)' );

    // Help
    StdAction.aboutApp( null, '', ac );
    StdAction.aboutKDE( null, '', ac );
    StdAction.help( null, '', ac );
    StdAction.helpContents( null, '', ac );
}

//
// Activate XMLGUI and show the window
//
load( 'imunge_actions.js' );
mw.setup_actions();

cwd = (new TQDir()).absPath();
mw.createGUI( cwd + '/imungeui.rc' );
mw.resize( 700, 500 );

if ( application.args.length )
    mw.load( application.args[0] );

mw.show();
mw.update_layout();

application.exec();
