#include <stream.h>
#include <stdio.h>


#include "test_impl.h"


void test_impl::noArg()
{
  printf("SERVER: noArg() called\n");
}


void test_impl::asyncNoArg()
{
  printf("SERVER: asyncNoArg() called\n");
}


void test_impl::oneArg(bool b)
{
  printf("SERVER: oneArg(");
  printf(b ? "true" : "false");
  printf(") called\n");
}


bool test_impl::returnFalse()
{
  printf("SERVER: returnFalse() called\n");
  return false;
}


bool test_impl::returnTrue()
{
  printf("SERVER: returnTrue() called\n");
  return true;
}


short test_impl::shortArg(short in)
{
  cout << "SERVER: short in: " << in << endl;
  return 123;
}


int test_impl::intArg(int in)
{
  cout << "SERVER: int in: " << in << endl;
  return 123456;
}


long test_impl::longArg(long in)
{
  cout << "SERVER: long in: " << in << endl;
  return 1234567890;
}


float test_impl::floatArg(float in)
{
  cout << "SERVER: float in: " << in << endl;
  return 12.34;
}


double test_impl::doubleArg(double in)
{
  cout << "SERVER: double in: " << in << endl;
  return 12.12313123;
}


TQString test_impl::stringArg(TQString in)
{
  cout << "SERVER: TQString in: " << in << endl;
  return "Hello Java";
}


TQCString test_impl::cstringArg(TQCString in)
{
  cout << "SERVER: TQCString in: " << in << endl;
  return "Hello Java";
}


TQStringList test_impl::stringListArg(TQStringList in)
{
  cout << "SERVER: TQStringList in: ";
  for (uint i=0; i<in.count(); ++i)
    cout << in[i] << ", ";
  cout << endl;
  TQStringList result;
  result << "one" << "two" << "three";
  return result;
}


DCOPRef test_impl::DCOPRefArg(DCOPRef in)
{
    cout << "SERVER: DCOPRef in: " << in.app() << ", " 
	 << in.object() << ", " << in.type() << endl;
    return DCOPRef("application", "object", "type");
}
