/***************************************************************************
 *   Copyright (C) 2005 by Olivier Goffart   *
 *   ogoffart@kde.org   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef SOUND_H
#define SOUND_H

#include <tqmemarray.h>
#include <tqstring.h>
#include <tdemacros.h>

/**
@author Olivier Goffart
*/
class TDE_EXPORT Sound{
public:
    Sound();
    ~Sound();

	void load(const TQString &filename);
	void save(const TQString &filename) const;

	unsigned int size() const
	{
		return data.size();
	}

	inline float at(int pos) const
	{
		return (float)(data.at(pos))/max;
	}

	inline uint fs() const
	{
		return _fs;
	}

	TQMemArray<TQ_INT32> data;
	TQ_UINT32 max;
	uint _fs;
};

#endif
