

#ifndef PLUGINLOADERBASE_H
#define PLUGINLOADERBASE_H

#include <tqobject.h>
#include <tqstringlist.h>
#include <tqdom.h>

#include "config.h"

// TODO implement rank everywhere

/**
 * @short The base for all pluginloaders
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class PluginLoaderBase : public TQObject
{
    TQ_OBJECT
  
public:
    /**
     * Do we recommend this backend to the user
     */
    enum FeatureLevel
    {
        Full, // the backend provides full support
        Most, // most features are supported
        Basic // we'll have just basic support
    };

    /**
     * Just a small enum for our sampling rate units
     */
    enum Unit
    {
        Hz,
        KHz
    };

    /**
     * Constructor
     */
    PluginLoaderBase();

    /**
     * Destructor
     */
    virtual ~PluginLoaderBase();

    /** a list of all plugin files that are loaded at the moment */
//     TQStringList openPluginFiles;

    /** the dom tree for loading the xml file */
    TQDomDocument domTree;

public slots:
    /**
     * Unload all plugins
     */
    void unloadAll();

    /**
     * Unoad a specific plugin with name @p pluginName
     */
    void unload( TQString pluginName );

    /**
     * Unoad a specific plugin with name @p pluginName and delete the plugin file
     */
    void remove( TQString pluginName );
};

#endif // PLUGINLOADERBASE_H


/**

Each plugin package contains 3 files:
 - The plugin file ( $KDE_DIR/share/apps/soundkonverter/plugins/'filename' )
 - The format info file ( $KDE_DIR/share/apps/soundkonverter/format_infos/'lang'/'plugin'_'filename' )
 - The service menu ( $KDE_DIR/share/apps/konqueror/servicemenus/'filename' )

*/

