

#ifndef LOGGER_H
#define LOGGER_H

#include <tqobject.h>
#include <tqstringlist.h>
#include <tqdatetime.h>
#include <tqfile.h>
#include <tqtextstream.h>


/**
 * @short An item for every process that is logged
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class LoggerItem
{
public:
    /**
     * Constructor
     */
    LoggerItem();

    /**
     * Destructor
     */
    virtual ~LoggerItem();

    TQString filename;
    int id;
    TQStringList data;
    bool completed;
    int state; // 0 = ok, -1 = failed, 1 = other (soundKonverter)
    TQTime time;
    TQFile file;
    TQTextStream textStream;

};


/**
 * @short All data about the processes are collected here
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class Logger : public TQObject
{
    TQ_OBJECT
  
public:
    /**
     * Constructor
     */
    Logger();

    /**
     * Destructor
     */
    virtual ~Logger();

    void cleanUp();

    /**
     * Creates a new logger item and returns the id of it, @p filename is added to the new logger item
     */
    int registerProcess( const TQString& filename );

    /**
     * Adds the string @p data to the data of the logger item with id @p id
     */
    void log( int id, const TQString& data );

    /**
     * Returns the logger item with id @p id
     */
    LoggerItem* getLog( int id );

    /**
     * Returns a list of all logger items
     */
    TQValueList<LoggerItem*> getLogs();

private:
    /** the list of all logger items */
    TQValueList<LoggerItem*> processes;

    /** returns an unused random id */
    int getNewID();

public slots:
    void processCompleted( int id, int state );

signals:
    void removedProcess( int id );
    void updateProcess( int id );

};

#endif // LOGGER_H
