
#include "combobutton.h"

#include <tqlayout.h>
#include <tqstring.h>
#include <tqpixmap.h>
#include <tqstyle.h>
#include <kpushbutton.h>
#include <kcombobox.h>

ComboButton::ComboButton( TQWidget *parent, const char *name )
    : TQWidget( parent, name )
{
    m_increaseHeight = 0;

    TQGridLayout *grid = new TQGridLayout( this, 1, 1 );

    m_box = new KComboBox(this);
    grid->addWidget(m_box,0,0);

    connect( m_box, TQ_SIGNAL(activated(int)),
             this, TQ_SLOT(boxActivated(int))
           );

    m_button = new KPushButton( TQString(), this, "pushbutton" );
    grid->addWidget( m_button, 0, 0 );

    connect( m_button, TQ_SIGNAL(clicked()),
             this, TQ_SLOT(buttonClicked())
           );

    m_sizeMode = Max;

    balanceSize();
}

ComboButton::~ComboButton()
{
}

void ComboButton::balanceSize()
{
    int width;

    if( m_sizeMode == Max )
        width = m_box->sizeHint().width()-17;
    else
        width = m_button->sizeHint().width();

    int height = ( m_box->sizeHint().height() > m_button->sizeHint().height() ) ? m_box->sizeHint().height() : m_button->sizeHint().height();

    m_box->setFixedSize( width+17, height+m_increaseHeight );
    m_button->setFixedSize( width, height+m_increaseHeight );
}

void ComboButton::repaintButton()
{
    m_button->setText( m_box->currentText() );
    if(m_box->pixmap( m_box->currentItem()) )
        m_button->setIconSet( *m_box->pixmap(m_box->currentItem()) );
    balanceSize();
}

void ComboButton::insertItem( const TQString &text, int index )
{
    m_box->insertItem( text, index );
    repaintButton();
}

void ComboButton::insertItem( const TQPixmap &pixmap, const TQString &text, int index )
{
    m_box->insertItem( pixmap, text, index );
    repaintButton();
}

void ComboButton::increaseHeight( int height )
{
    m_increaseHeight = height;
    balanceSize();
}

void ComboButton::boxActivated( int index )
{
    repaintButton();
    emit clicked( index );
}

void ComboButton::buttonClicked()
{
    emit clicked( m_box->currentItem() );
}

void ComboButton::setSizeMode( int mode )
{
    m_sizeMode = mode;
    balanceSize();
}

int ComboButton::sizeMode()
{
    return m_sizeMode;
}

void ComboButton::setFont( const TQFont& font )
{
    m_button->setFont( font );
    m_box->setFont( font );
}

TQFont ComboButton::font()
{
    return m_button->font();
}

#include "combobutton.moc"
