--
-- Selected TOC Entries:
--
--
-- TOC Entry ID 1 (OID 0)
--
-- Name: testdb Type: DATABASE Owner: postgres
--

CREATE DATABASE "testdb";

\connect testdb postgres
--
-- TOC Entry ID 16 (OID 17332)
--
-- Name: people Type: TABLE Owner: postgres
--

CREATE TABLE "people" (
	"id" integer DEFAULT nextval('people_id_seq'::text) NOT NULL,
	"name" character(40),
	Constraint "people_pkey" Primary Key ("id")
);

--
-- TOC Entry ID 17 (OID 17335)
--
-- Name: staff Type: TABLE Owner: postgres
--

CREATE TABLE "staff" (
	"id" integer DEFAULT nextval('staff_id_seq'::text) NOT NULL,
	"forename" character(40),
	"surname" character(40),
	"salary" money,
	"statusid" integer,
	Constraint "staff_pkey" Primary Key ("id")
);

--
-- TOC Entry ID 18 (OID 17338)
--
-- Name: status Type: TABLE Owner: postgres
--

CREATE TABLE "status" (
	"id" integer NOT NULL,
	"name" character(30),
	Constraint "status_pkey" Primary Key ("id")
);

--
-- TOC Entry ID 19 (OID 17341)
--
-- Name: creditors Type: TABLE Owner: postgres
--

CREATE TABLE "creditors" (
	"id" integer DEFAULT nextval('creditors_id_seq'::text) NOT NULL,
	"forename" character(40),
	"surname" character(40),
	"city" character(30),
	Constraint "creditors_pkey" Primary Key ("id")
);

--
-- TOC Entry ID 20 (OID 17344)
--
-- Name: prices Type: TABLE Owner: postgres
--

CREATE TABLE "prices" (
	"id" integer NOT NULL,
	"name" character(40),
	"price" real,
	Constraint "prices_pkey" Primary Key ("id")
);

--
-- TOC Entry ID 21 (OID 17347)
--
-- Name: invoiceitem Type: TABLE Owner: postgres
--

CREATE TABLE "invoiceitem" (
	"id" integer DEFAULT nextval('invoice_id_seq'::text) NOT NULL,
	"pricesid" integer,
	"quantity" integer,
	"paiddate" date,
	Constraint "invoiceitem_pkey" Primary Key ("id")
);

--
-- TOC Entry ID 2 (OID 17351)
--
-- Name: people_id_seq Type: SEQUENCE Owner: postgres
--

CREATE SEQUENCE "people_id_seq" start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1;

--
-- TOC Entry ID 4 (OID 17353)
--
-- Name: staff_id_seq Type: SEQUENCE Owner: postgres
--

CREATE SEQUENCE "staff_id_seq" start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1;

--
-- TOC Entry ID 6 (OID 17355)
--
-- Name: creditors_id_seq Type: SEQUENCE Owner: postgres
--

CREATE SEQUENCE "creditors_id_seq" start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1;

--
-- TOC Entry ID 8 (OID 17357)
--
-- Name: invoice_id_seq Type: SEQUENCE Owner: postgres
--

CREATE SEQUENCE "invoice_id_seq" start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1;

--
-- Data for TOC Entry ID 28 (OID 17332)
--
-- Name: people Type: TABLE DATA Owner: postgres
--


COPY "people" FROM stdin;
\.
--
-- Data for TOC Entry ID 29 (OID 17335)
--
-- Name: staff Type: TABLE DATA Owner: postgres
--


COPY "staff" FROM stdin;
1	Hugo                                    	Hurtig                                  	$123,450.50	0
2	Alfred E.                               	Neumann                                 	$56,780.90	1
3	Agate                                   	Schnell-Fertig                          	$12,340.56	2
6	Eugen                                   	Nutzlos                                 	-$7,833.56	3
7	Harald                                  	Schmidt                                 	-$150,000.00	3
4	Urmel                                   	auf dem Eis                             	$7,778.00	2
5	Emil                                    	Dotterschreck                           	-$5,670.23	3
\.
--
-- Data for TOC Entry ID 30 (OID 17338)
--
-- Name: status Type: TABLE DATA Owner: postgres
--


COPY "status" FROM stdin;
0	Chief                         
1	Programmer                    
2	Secretary                     
3	Driver                        
\.
--
-- Data for TOC Entry ID 31 (OID 17341)
--
-- Name: creditors Type: TABLE DATA Owner: postgres
--


COPY "creditors" FROM stdin;
\.
--
-- Data for TOC Entry ID 32 (OID 17344)
--
-- Name: prices Type: TABLE DATA Owner: postgres
--


COPY "prices" FROM stdin;
0	Waschbecken                             	150.25
1	Wellensittich                           	27.95
2	Roter Papagei                           	850
3	Spam & Eggs                             	-7.5
4	Renault Espace                          	9000
5	Tux, der Pinguin                        	65.35
6	Makroskop                               	985000
7	Regenbaum                               	1235.65
8	Blutergu                               	23.95
9	Weltmeisterschaft                       	2.95
10	Premiere Dekoder                        	-185.75
\.
--
-- Data for TOC Entry ID 33 (OID 17347)
--
-- Name: invoiceitem Type: TABLE DATA Owner: postgres
--


COPY "invoiceitem" FROM stdin;
\.
--
-- TOC Entry ID 3 (OID 17351)
--
-- Name: people_id_seq Type: SEQUENCE SET Owner: postgres
--

SELECT setval ('"people_id_seq"', 1, false);

--
-- TOC Entry ID 5 (OID 17353)
--
-- Name: staff_id_seq Type: SEQUENCE SET Owner: postgres
--

SELECT setval ('"staff_id_seq"', 8, true);

--
-- TOC Entry ID 7 (OID 17355)
--
-- Name: creditors_id_seq Type: SEQUENCE SET Owner: postgres
--

SELECT setval ('"creditors_id_seq"', 1, false);

--
-- TOC Entry ID 9 (OID 17357)
--
-- Name: invoice_id_seq Type: SEQUENCE SET Owner: postgres
--

SELECT setval ('"invoice_id_seq"', 1, false);

