//
// Register Declarations for Microchip 16F873 Processor
//
//
// This header file was automatically generated by:
//
//	inc2h.pl V1.5
//
//	Copyright (c) 2002, Kevin L. Pauba, All Rights Reserved
//
//	SDCC is licensed under the GNU Public license (GPL) v2.  Note that
//	this license covers the code to the compiler and other executables,
//	but explicitly does not cover any code or objects generated by sdcc.
//	We have not yet decided on a license for the run time libraries, but
//	it will not put any requirements on code linked against it. See:
// 
//	http://www.gnu.org/copyleft/gpl/html
//
//	See http://sdcc.sourceforge.net/ for the latest information on sdcc.
//
// 
#ifndef P16F873_H
#define P16F873_H

#define udata udata_shr

#ifndef BIT_AT
#define BIT_AT(base,bitno) sbit at ((base<<3)+bitno)
#endif

//
// Register addresses.
//
#define INDF_ADDR	0x0000
#define TMR0_ADDR	0x0001
#define PCL_ADDR	0x0002
#define STATUS_ADDR	0x0003
#define FSR_ADDR	0x0004
#define PORTA_ADDR	0x0005
#define PORTB_ADDR	0x0006
#define PORTC_ADDR	0x0007
#define PCLATH_ADDR	0x000A
#define INTCON_ADDR	0x000B
#define PIR1_ADDR	0x000C
#define PIR2_ADDR	0x000D
#define TMR1L_ADDR	0x000E
#define TMR1H_ADDR	0x000F
#define T1CON_ADDR	0x0010
#define TMR2_ADDR	0x0011
#define T2CON_ADDR	0x0012
#define SSPBUF_ADDR	0x0013
#define SSPCON_ADDR	0x0014
#define CCPR1L_ADDR	0x0015
#define CCPR1H_ADDR	0x0016
#define CCP1CON_ADDR	0x0017
#define RCSTA_ADDR	0x0018
#define TXREG_ADDR	0x0019
#define RCREG_ADDR	0x001A
#define CCPR2L_ADDR	0x001B
#define CCPR2H_ADDR	0x001C
#define CCP2CON_ADDR	0x001D
#define ADRESH_ADDR	0x001E
#define ADCON0_ADDR	0x001F
#define OPTION_REG_ADDR	0x0081
#define TRISA_ADDR	0x0085
#define TRISB_ADDR	0x0086
#define TRISC_ADDR	0x0087
#define PIE1_ADDR	0x008C
#define PIE2_ADDR	0x008D
#define PCON_ADDR	0x008E
#define SSPCON2_ADDR	0x0091
#define PR2_ADDR	0x0092
#define SSPADD_ADDR	0x0093
#define SSPSTAT_ADDR	0x0094
#define TXSTA_ADDR	0x0098
#define SPBRG_ADDR	0x0099
#define ADRESL_ADDR	0x009E
#define ADCON1_ADDR	0x009F
#define EEDATA_ADDR	0x010C
#define EEADR_ADDR	0x010D
#define EEDATH_ADDR	0x010E
#define EEADRH_ADDR	0x010F
#define EECON1_ADDR	0x018C
#define EECON2_ADDR	0x018D

//
// Memory organization.
//
#pragma maxram 0x1FF

#pragma memmap 0x0020 0x007f RAM 0x100
#pragma memmap 0x00a0 0x00ff RAM 0x100

#pragma memmap INDF_ADDR INDF_ADDR SFR 0x000	// INDF
#pragma memmap TMR0_ADDR TMR0_ADDR SFR 0x000	// TMR0
#pragma memmap PCL_ADDR PCL_ADDR SFR 0x000	// PCL
#pragma memmap STATUS_ADDR STATUS_ADDR SFR 0x000	// STATUS
#pragma memmap FSR_ADDR FSR_ADDR SFR 0x000	// FSR
#pragma memmap PORTA_ADDR PORTA_ADDR SFR 0x000	// PORTA
#pragma memmap PORTB_ADDR PORTB_ADDR SFR 0x000	// PORTB
#pragma memmap PORTC_ADDR PORTC_ADDR SFR 0x000	// PORTC
#pragma memmap PCLATH_ADDR PCLATH_ADDR SFR 0x000	// PCLATH
#pragma memmap INTCON_ADDR INTCON_ADDR SFR 0x000	// INTCON
#pragma memmap PIR1_ADDR PIR1_ADDR SFR 0x000	// PIR1
#pragma memmap PIR2_ADDR PIR2_ADDR SFR 0x000	// PIR2
#pragma memmap TMR1L_ADDR TMR1L_ADDR SFR 0x000	// TMR1L
#pragma memmap TMR1H_ADDR TMR1H_ADDR SFR 0x000	// TMR1H
#pragma memmap T1CON_ADDR T1CON_ADDR SFR 0x000	// T1CON
#pragma memmap TMR2_ADDR TMR2_ADDR SFR 0x000	// TMR2
#pragma memmap T2CON_ADDR T2CON_ADDR SFR 0x000	// T2CON
#pragma memmap SSPBUF_ADDR SSPBUF_ADDR SFR 0x000	// SSPBUF
#pragma memmap SSPCON_ADDR SSPCON_ADDR SFR 0x000	// SSPCON
#pragma memmap CCPR1L_ADDR CCPR1L_ADDR SFR 0x000	// CCPR1L
#pragma memmap CCPR1H_ADDR CCPR1H_ADDR SFR 0x000	// CCPR1H
#pragma memmap CCP1CON_ADDR CCP1CON_ADDR SFR 0x000	// CCP1CON
#pragma memmap RCSTA_ADDR RCSTA_ADDR SFR 0x000	// RCSTA
#pragma memmap TXREG_ADDR TXREG_ADDR SFR 0x000	// TXREG
#pragma memmap RCREG_ADDR RCREG_ADDR SFR 0x000	// RCREG
#pragma memmap CCPR2L_ADDR CCPR2L_ADDR SFR 0x000	// CCPR2L
#pragma memmap CCPR2H_ADDR CCPR2H_ADDR SFR 0x000	// CCPR2H
#pragma memmap CCP2CON_ADDR CCP2CON_ADDR SFR 0x000	// CCP2CON
#pragma memmap ADRESH_ADDR ADRESH_ADDR SFR 0x000	// ADRESH
#pragma memmap ADCON0_ADDR ADCON0_ADDR SFR 0x000	// ADCON0
#pragma memmap OPTION_REG_ADDR OPTION_REG_ADDR SFR 0x000	// OPTION_REG
#pragma memmap TRISA_ADDR TRISA_ADDR SFR 0x000	// TRISA
#pragma memmap TRISB_ADDR TRISB_ADDR SFR 0x000	// TRISB
#pragma memmap TRISC_ADDR TRISC_ADDR SFR 0x000	// TRISC
#pragma memmap PIE1_ADDR PIE1_ADDR SFR 0x000	// PIE1
#pragma memmap PIE2_ADDR PIE2_ADDR SFR 0x000	// PIE2
#pragma memmap PCON_ADDR PCON_ADDR SFR 0x000	// PCON
#pragma memmap SSPCON2_ADDR SSPCON2_ADDR SFR 0x000	// SSPCON2
#pragma memmap PR2_ADDR PR2_ADDR SFR 0x000	// PR2
#pragma memmap SSPADD_ADDR SSPADD_ADDR SFR 0x000	// SSPADD
#pragma memmap SSPSTAT_ADDR SSPSTAT_ADDR SFR 0x000	// SSPSTAT
#pragma memmap TXSTA_ADDR TXSTA_ADDR SFR 0x000	// TXSTA
#pragma memmap SPBRG_ADDR SPBRG_ADDR SFR 0x000	// SPBRG
#pragma memmap ADRESL_ADDR ADRESL_ADDR SFR 0x000	// ADRESL
#pragma memmap ADCON1_ADDR ADCON1_ADDR SFR 0x000	// ADCON1
#pragma memmap EEDATA_ADDR EEDATA_ADDR SFR 0x000	// EEDATA
#pragma memmap EEADR_ADDR EEADR_ADDR SFR 0x000	// EEADR
#pragma memmap EEDATH_ADDR EEDATH_ADDR SFR 0x000	// EEDATH
#pragma memmap EEADRH_ADDR EEADRH_ADDR SFR 0x000	// EEADRH
#pragma memmap EECON1_ADDR EECON1_ADDR SFR 0x000	// EECON1
#pragma memmap EECON2_ADDR EECON2_ADDR SFR 0x000	// EECON2


//         LIST
// P16F873.INC  Standard Header File, Version 1.00    Microchip Technology, Inc.
//         NOLIST

// This header file defines configurations, registers, and other useful bits of
// information for the PIC16F873 microcontroller.  These names are taken to match 
// the data sheets as closely as possible.  

// Note that the processor must be selected before this file is 
// included.  The processor may be selected the following ways:

//       1. Command line switch:
//               C:\ MPASM MYFILE.ASM /PIC16F873
//       2. LIST directive in the source file
//               LIST   P=PIC16F873
//       3. Processor Type entry in the MPASM full-screen interface

//==========================================================================
//
//       Revision History
//
//==========================================================================

//Rev:   Date:    Reason:

//1.12   01/12/00 Changed some bit names, a register name, configuration bits
//                 to match datasheet (DS30292B)
//1.11   10/18/98 Changes to file registers to match updated DOS
//1.10   08/17/98 Fixed typo in processor name, RCSTA and ADCON1 
//1.00   08/07/98 Initial Release

//==========================================================================
//
//       Verify Processor
//
//==========================================================================

//        IFNDEF __16F873
//            MESSG "Processor-header file mismatch.  Verify selected processor."
//         ENDIF

//==========================================================================
//
//       Register Definitions
//
//==========================================================================

#define W                    0x0000
#define F                    0x0001

//----- Register Files------------------------------------------------------

data at INDF_ADDR volatile char        INDF;
sfr  at TMR0_ADDR                      TMR0;
data at PCL_ADDR volatile char         PCL;
sfr  at STATUS_ADDR                    STATUS;
sfr  at FSR_ADDR                       FSR;
sfr  at PORTA_ADDR                     PORTA;
sfr  at PORTB_ADDR                     PORTB;
sfr  at PORTC_ADDR                     PORTC;
sfr  at PCLATH_ADDR                    PCLATH;
sfr  at INTCON_ADDR                    INTCON;
sfr  at PIR1_ADDR                      PIR1;
sfr  at PIR2_ADDR                      PIR2;
sfr  at TMR1L_ADDR                     TMR1L;
sfr  at TMR1H_ADDR                     TMR1H;
sfr  at T1CON_ADDR                     T1CON;
sfr  at TMR2_ADDR                      TMR2;
sfr  at T2CON_ADDR                     T2CON;
sfr  at SSPBUF_ADDR                    SSPBUF;
sfr  at SSPCON_ADDR                    SSPCON;
sfr  at CCPR1L_ADDR                    CCPR1L;
sfr  at CCPR1H_ADDR                    CCPR1H;
sfr  at CCP1CON_ADDR                   CCP1CON;
sfr  at RCSTA_ADDR                     RCSTA;
sfr  at TXREG_ADDR                     TXREG;
sfr  at RCREG_ADDR                     RCREG;
sfr  at CCPR2L_ADDR                    CCPR2L;
sfr  at CCPR2H_ADDR                    CCPR2H;
sfr  at CCP2CON_ADDR                   CCP2CON;
sfr  at ADRESH_ADDR                    ADRESH;
sfr  at ADCON0_ADDR                    ADCON0;

sfr  at OPTION_REG_ADDR                OPTION_REG;
sfr  at TRISA_ADDR                     TRISA;
sfr  at TRISB_ADDR                     TRISB;
sfr  at TRISC_ADDR                     TRISC;
sfr  at PIE1_ADDR                      PIE1;
sfr  at PIE2_ADDR                      PIE2;
sfr  at PCON_ADDR                      PCON;
sfr  at SSPCON2_ADDR                   SSPCON2;
sfr  at PR2_ADDR                       PR2;
sfr  at SSPADD_ADDR                    SSPADD;
sfr  at SSPSTAT_ADDR                   SSPSTAT;
sfr  at TXSTA_ADDR                     TXSTA;
sfr  at SPBRG_ADDR                     SPBRG;
sfr  at ADRESL_ADDR                    ADRESL;
sfr  at ADCON1_ADDR                    ADCON1;

sfr  at EEDATA_ADDR                    EEDATA;
sfr  at EEADR_ADDR                     EEADR;
sfr  at EEDATH_ADDR                    EEDATH;
sfr  at EEADRH_ADDR                    EEADRH;

sfr  at EECON1_ADDR                    EECON1;
sfr  at EECON2_ADDR                    EECON2;
//----- STATUS Bits --------------------------------------------------------

BIT_AT(STATUS_ADDR,7)	IRP;
BIT_AT(STATUS_ADDR,6)	RP1;
BIT_AT(STATUS_ADDR,5)	RP0;
BIT_AT(STATUS_ADDR,4)	NOT_TO;
BIT_AT(STATUS_ADDR,3)	NOT_PD;
BIT_AT(STATUS_ADDR,2)	Z;
BIT_AT(STATUS_ADDR,1)	DC;
BIT_AT(STATUS_ADDR,0)	C;

//----- INTCON Bits --------------------------------------------------------

BIT_AT(INTCON_ADDR,7)	GIE;
BIT_AT(INTCON_ADDR,6)	PEIE;
BIT_AT(INTCON_ADDR,5)	T0IE;
BIT_AT(INTCON_ADDR,4)	INTE;
BIT_AT(INTCON_ADDR,3)	RBIE;
BIT_AT(INTCON_ADDR,2)	T0IF;
BIT_AT(INTCON_ADDR,1)	INTF;
BIT_AT(INTCON_ADDR,0)	RBIF;

//----- PIR1 Bits ----------------------------------------------------------
BIT_AT(PIR1_ADDR,6)	ADIF;
BIT_AT(PIR1_ADDR,5)	RCIF;
BIT_AT(PIR1_ADDR,4)	TXIF;
BIT_AT(PIR1_ADDR,3)	SSPIF;
BIT_AT(PIR1_ADDR,2)	CCP1IF;
BIT_AT(PIR1_ADDR,1)	TMR2IF;
BIT_AT(PIR1_ADDR,0)	TMR1IF;

//----- PIR2 Bits ----------------------------------------------------------

BIT_AT(PIR2_ADDR,6)	CMIF;
BIT_AT(PIR2_ADDR,4)	EEIF;   
BIT_AT(PIR2_ADDR,3)	BCLIF;
BIT_AT(PIR2_ADDR,0)	CCP2IF;

//----- T1CON Bits ---------------------------------------------------------

BIT_AT(T1CON_ADDR,5)	T1CKPS1;
BIT_AT(T1CON_ADDR,4)	T1CKPS0;
BIT_AT(T1CON_ADDR,3)	T1OSCEN;
BIT_AT(T1CON_ADDR,2)	NOT_T1SYNC;
BIT_AT(T1CON_ADDR,2)	T1INSYNC;    // Backward compatibility only
BIT_AT(T1CON_ADDR,2)	T1SYNC;
BIT_AT(T1CON_ADDR,1)	TMR1CS;
BIT_AT(T1CON_ADDR,0)	TMR1ON;

//----- T2CON Bits ---------------------------------------------------------

BIT_AT(T2CON_ADDR,6)	TOUTPS3;
BIT_AT(T2CON_ADDR,5)	TOUTPS2;
BIT_AT(T2CON_ADDR,4)	TOUTPS1;
BIT_AT(T2CON_ADDR,3)	TOUTPS0;
BIT_AT(T2CON_ADDR,2)	TMR2ON;
BIT_AT(T2CON_ADDR,1)	T2CKPS1;
BIT_AT(T2CON_ADDR,0)	T2CKPS0;

//----- SSPCON Bits --------------------------------------------------------

BIT_AT(SSPCON_ADDR,7)	WCOL;
BIT_AT(SSPCON_ADDR,6)	SSPOV;
BIT_AT(SSPCON_ADDR,5)	SSPEN;
BIT_AT(SSPCON_ADDR,4)	CKP;
BIT_AT(SSPCON_ADDR,3)	SSPM3;
BIT_AT(SSPCON_ADDR,2)	SSPM2;
BIT_AT(SSPCON_ADDR,1)	SSPM1;
BIT_AT(SSPCON_ADDR,0)	SSPM0;

//----- CCP1CON Bits -------------------------------------------------------

BIT_AT(CCP1CON_ADDR,5)	CCP1X;
BIT_AT(CCP1CON_ADDR,4)	CCP1Y;
BIT_AT(CCP1CON_ADDR,3)	CCP1M3;
BIT_AT(CCP1CON_ADDR,2)	CCP1M2;
BIT_AT(CCP1CON_ADDR,1)	CCP1M1;
BIT_AT(CCP1CON_ADDR,0)	CCP1M0;

//----- RCSTA Bits ---------------------------------------------------------

BIT_AT(RCSTA_ADDR,7)	SPEN;
BIT_AT(RCSTA_ADDR,6)	RX9;
BIT_AT(RCSTA_ADDR,6)	RC9;    // Backward compatibility only
BIT_AT(RCSTA_ADDR,6)	NOT_RC8;    // Backward compatibility only
BIT_AT(RCSTA_ADDR,6)	RC8_9;    // Backward compatibility only
BIT_AT(RCSTA_ADDR,5)	SREN;
BIT_AT(RCSTA_ADDR,4)	CREN;
BIT_AT(RCSTA_ADDR,3)	ADDEN;
BIT_AT(RCSTA_ADDR,2)	FERR;
BIT_AT(RCSTA_ADDR,1)	OERR;
BIT_AT(RCSTA_ADDR,0)	RX9D;
BIT_AT(RCSTA_ADDR,0)	RCD8;    // Backward compatibility only

//----- CCP2CON Bits -------------------------------------------------------

BIT_AT(CCP2CON_ADDR,5)	CCP2X;
BIT_AT(CCP2CON_ADDR,4)	CCP2Y;
BIT_AT(CCP2CON_ADDR,3)	CCP2M3;
BIT_AT(CCP2CON_ADDR,2)	CCP2M2;
BIT_AT(CCP2CON_ADDR,1)	CCP2M1;
BIT_AT(CCP2CON_ADDR,0)	CCP2M0;

//----- ADCON0 Bits --------------------------------------------------------

BIT_AT(ADCON0_ADDR,7)	ADCS1;
BIT_AT(ADCON0_ADDR,6)	ADCS0;
BIT_AT(ADCON0_ADDR,5)	CHS2;
BIT_AT(ADCON0_ADDR,4)	CHS1;
BIT_AT(ADCON0_ADDR,3)	CHS0;
BIT_AT(ADCON0_ADDR,2)	GO;
BIT_AT(ADCON0_ADDR,2)	NOT_DONE;
BIT_AT(ADCON0_ADDR,2)	GO_DONE;
BIT_AT(ADCON0_ADDR,0)	ADON;

//----- OPTION_REG Bits ----------------------------------------------------

BIT_AT(OPTION_REG_ADDR,7)	NOT_RBPU;
BIT_AT(OPTION_REG_ADDR,6)	INTEDG;
BIT_AT(OPTION_REG_ADDR,5)	T0CS;
BIT_AT(OPTION_REG_ADDR,4)	T0SE;
BIT_AT(OPTION_REG_ADDR,3)	PSA;
BIT_AT(OPTION_REG_ADDR,2)	PS2;
BIT_AT(OPTION_REG_ADDR,1)	PS1;
BIT_AT(OPTION_REG_ADDR,0)	PS0;

//----- PIE1 Bits ----------------------------------------------------------

BIT_AT(PIE1_ADDR,6)	ADIE;
BIT_AT(PIE1_ADDR,5)	RCIE;
BIT_AT(PIE1_ADDR,4)	TXIE;
BIT_AT(PIE1_ADDR,3)	SSPIE;
BIT_AT(PIE1_ADDR,2)	CCP1IE;
BIT_AT(PIE1_ADDR,1)	TMR2IE;
BIT_AT(PIE1_ADDR,0)	TMR1IE;

//----- PIE2 Bits ----------------------------------------------------------

BIT_AT(PIE2_ADDR,4)	EEIE;   
BIT_AT(PIE2_ADDR,3)	BCLIE;
BIT_AT(PIE2_ADDR,0)	CCP2IE;

//----- PCON Bits ----------------------------------------------------------

BIT_AT(PCON_ADDR,1)	NOT_POR;
BIT_AT(PCON_ADDR,0)	NOT_BO;
BIT_AT(PCON_ADDR,0)	NOT_BOR;

//----- SSPCON2 Bits --------------------------------------------------------

BIT_AT(SSPCON2_ADDR,7)	GCEN;
BIT_AT(SSPCON2_ADDR,6)	ACKSTAT;
BIT_AT(SSPCON2_ADDR,5)	ACKDT;
BIT_AT(SSPCON2_ADDR,4)	ACKEN;
BIT_AT(SSPCON2_ADDR,3)	RCEN;
BIT_AT(SSPCON2_ADDR,2)	PEN;
BIT_AT(SSPCON2_ADDR,1)	RSEN;   
BIT_AT(SSPCON2_ADDR,0)	SEN;   

//----- SSPSTAT Bits -------------------------------------------------------

BIT_AT(SSPSTAT_ADDR,7)	SMP;
BIT_AT(SSPSTAT_ADDR,6)	CKE;
BIT_AT(SSPSTAT_ADDR,5)	D;
BIT_AT(SSPSTAT_ADDR,5)	I2C_DATA;
BIT_AT(SSPSTAT_ADDR,5)	NOT_A;
BIT_AT(SSPSTAT_ADDR,5)	NOT_ADDRESS;
BIT_AT(SSPSTAT_ADDR,5)	D_A;
BIT_AT(SSPSTAT_ADDR,5)	DATA_ADDRESS;
BIT_AT(SSPSTAT_ADDR,4)	P;
BIT_AT(SSPSTAT_ADDR,4)	I2C_STOP;
BIT_AT(SSPSTAT_ADDR,3)	S;
BIT_AT(SSPSTAT_ADDR,3)	I2C_START;
BIT_AT(SSPSTAT_ADDR,2)	R;
BIT_AT(SSPSTAT_ADDR,2)	I2C_READ;
BIT_AT(SSPSTAT_ADDR,2)	NOT_W;
BIT_AT(SSPSTAT_ADDR,2)	NOT_WRITE;
BIT_AT(SSPSTAT_ADDR,2)	R_W;
BIT_AT(SSPSTAT_ADDR,2)	READ_WRITE;
BIT_AT(SSPSTAT_ADDR,1)	UA;
BIT_AT(SSPSTAT_ADDR,0)	BF;

//----- TXSTA Bits ---------------------------------------------------------

BIT_AT(TXSTA_ADDR,7)	CSRC;
BIT_AT(TXSTA_ADDR,6)	TX9;
BIT_AT(TXSTA_ADDR,6)	NOT_TX8;    // Backward compatibility only
BIT_AT(TXSTA_ADDR,6)	TX8_9;    // Backward compatibility only
BIT_AT(TXSTA_ADDR,5)	TXEN;
BIT_AT(TXSTA_ADDR,4)	SYNC;
BIT_AT(TXSTA_ADDR,2)	BRGH;
BIT_AT(TXSTA_ADDR,1)	TRMT;
BIT_AT(TXSTA_ADDR,0)	TX9D;
BIT_AT(TXSTA_ADDR,0)	TXD8;    // Backward compatibility only

//----- ADCON1 Bits --------------------------------------------------------

BIT_AT(ADCON1_ADDR,7)	ADFM;
BIT_AT(ADCON1_ADDR,3)	PCFG3;
BIT_AT(ADCON1_ADDR,2)	PCFG2;
BIT_AT(ADCON1_ADDR,1)	PCFG1;
BIT_AT(ADCON1_ADDR,0)	PCFG0;

//----- EECON1 Bits --------------------------------------------------------

BIT_AT(EECON1_ADDR,7)	EEPGD;
BIT_AT(EECON1_ADDR,3)	WRERR;
BIT_AT(EECON1_ADDR,2)	WREN;
BIT_AT(EECON1_ADDR,1)	WR;
BIT_AT(EECON1_ADDR,0)	RD;

//==========================================================================
//
//       RAM Definition
//
//==========================================================================

//         __MAXRAM H'1FF'
//         __BADRAM H'8F'-H'90', H'95'-H'97', H'9A'-H'9D'
//         __BADRAM H'105', H'107'-H'109', H'110'-H'11F'
//         __BADRAM H'185', H'187'-H'189', H'18E'-H'19F'

//==========================================================================
//
//       Configuration Bits
//
//==========================================================================

#define _CP_ALL              0x0FCF
#define _CP_HALF             0x1FDF
#define _CP_UPPER_256        0x2FEF
#define _CP_OFF              0x3FFF
#define _DEBUG_ON            0x37FF
#define _DEBUG_OFF           0x3FFF
#define _WRT_ENABLE_ON       0x3FFF
#define _WRT_ENABLE_OFF      0x3DFF
#define _CPD_ON              0x3EFF
#define _CPD_OFF             0x3FFF
#define _LVP_ON              0x3FFF 
#define _LVP_OFF             0x3F7F	
#define _BODEN_ON            0x3FFF
#define _BODEN_OFF           0x3FBF
#define _PWRTE_OFF           0x3FFF
#define _PWRTE_ON            0x3FF7
#define _WDT_ON              0x3FFF
#define _WDT_OFF             0x3FFB
#define _LP_OSC              0x3FFC
#define _XT_OSC              0x3FFD
#define _HS_OSC              0x3FFE
#define _RC_OSC              0x3FFF

//         LIST
#endif
