/***************************************************************************
 *   Copyright (C) 2006 Nicolas Hadacek <hadacek@kde.org>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef PIC30_H
#define PIC30_H

#include "tools/base/tool_group.h"

namespace PIC30
{

//----------------------------------------------------------------------------
class Base : public Tool::Base
{
public:
  virtual TQString baseExecutable(bool withWine, Tool::OutputExecutableType type) const;

private:
  virtual TQStringList checkExecutableOptions(bool withWine) const;
  virtual bool checkExecutableResult(bool withWine, TQStringList &lines) const;
};

//----------------------------------------------------------------------------
class Group : public Tool::Group
{
public:
  virtual TQString name() const { return "pic30"; }
  virtual TQString label() const { return i18n("PIC30 Toolchain"); }
  virtual TQString informationText() const;
  virtual bool hasDirectory(Compile::DirectoryType type) const { return type==Compile::DirectoryType::Header || type==Compile::DirectoryType::LinkerScript || type==Compile::DirectoryType::Library; }
  virtual PURL::Directory autodetectDirectory(Compile::DirectoryType type, const PURL::Directory &execDir, bool withWine) const;
  virtual bool hasOutputExecutableType(Tool::OutputExecutableType type) const { return ( type==Tool::OutputExecutableType::Coff || type==Tool::OutputExecutableType::Elf ); }
  virtual Tool::Category checkDevicesCategory() const { return Tool::Category::Nb_Types; }
  virtual Tool::ExecutableType preferedExecutableType() const { return Tool::ExecutableType::Unix; }
  virtual Tool::CompileType compileType() const { return Tool::SeparateFiles; }
  virtual PURL::FileType linkerScriptType() const { return PURL::Gld; }
  virtual PURL::FileType implementationType(PURL::ToolType type) const;

private:
  virtual BaseData baseFactory(Tool::Category category) const;
  virtual TQValueList<const Device::Data *> getSupportedDevices(const TQString &s) const;
  virtual Compile::Process *processFactory(const Compile::Data &data) const;
  virtual Compile::Config *configFactory(::Project *project) const;
  virtual Tool::SourceGenerator *sourceGeneratorFactory() const;
};

} // namespace

#endif
