#ifndef _NOTIFIERMESSAGE_H_
#define _NOTIFIERMESSAGE_H_
//=============================================================================
//
//   File : notifiermessage.h
//   Created on mar 02 nov 2004 02:41:18 by 
//		Iacopo Palazzi < iakko(at)siena(dot)linux(dot)it >
//
//   This file is part of the KVIrc distribution
//   Copyright (C) 2004 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================


#include "kvi_settings.h"

#include <tqwidget.h>
#include <tqrect.h>
#include <tqtimer.h>
#include <tqpixmap.h>
#include <tqimage.h>
#include <tqfont.h>
#include <tqcolor.h>
#include <tqlineedit.h>

#include "kvi_qstring.h"
#include "kvi_pointerlist.h"
#include "kvi_time.h"

	#include <tqsimplerichtext.h>

class KviWindow;
class KviNotifierWindow;

class TQPopupMenu;

class KviNotifierMessage
{
	friend class KviNotifierWindow;
public:
	KviNotifierMessage(KviNotifierWindow * pNotifierWindow, TQPixmap * pImage, const TQString &szText);
	~KviNotifierMessage();

// ================================
// Put members declaration below...
// ================================
private:

public:

protected:
	KviWindow       * m_pWindow;
	TQPixmap         * m_pImage;
	TQSimpleRichText * m_pText;
	bool              m_bHistoric;

// ================================
// Put methods declaration below...
// ================================
private:

public:
	bool historic(){ return m_bHistoric; };
	void setHistoric();
	void setWindow(KviWindow * pWnd){ m_pWindow = pWnd; };
	TQPixmap * image(){ return m_pImage; };
	TQSimpleRichText * text(){ return m_pText; };
	
protected:


};

#define NUM_OLD_COLORS 6

#endif //!_NOTIFIERMESSAGE_H_
