#ifndef _KVI_MDICAPTION_H_
#define _KVI_MDICAPTION_H_
//=================================================================================================
//
//   File : kvi_mdicaption.h
//   Creation date : Tue Sep 2 2003 02:35:45 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2003 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=================================================================================================

#include "kvi_settings.h"

#include <tqtoolbutton.h>
#include <tqlabel.h>
#include "kvi_styled_controls.h"

class KviMdiManager;
class KviMdiChild;


class KVIRC_API KviMdiCaptionButton : public TQToolButton
{
	TQ_OBJECT
  
public:
	KviMdiCaptionButton(const TQPixmap &pix,TQWidget * parent,const char * name);
	~KviMdiCaptionButton();
protected:
	virtual void drawButton(TQPainter * p);
};


class KviMenuBarToolButton : public KviStyledToolButton
{
	TQ_OBJECT
  
public:
	KviMenuBarToolButton(TQWidget * par,const TQPixmap &img, const char * name);
	~KviMenuBarToolButton();
public:
	virtual TQSize sizeHint() const;
};


class KVIRC_API KviMdiCaption : public TQWidget
{
	friend class KviMdiChild;
	TQ_OBJECT
  
public:
	KviMdiCaption(KviMdiChild * parent,const char * name);
	~KviMdiCaption();
protected:
	TQPoint                m_lastMousePos;
	bool                  m_bMouseGrabbed;
	int                   m_iLineSpacing;
	bool                  m_bActive;
	KviMdiCaptionButton * m_pSystemButton;
	KviMdiCaptionButton * m_pMinimizeButton;
	KviMdiCaptionButton * m_pMaximizeButton;
	KviMdiCaptionButton * m_pCloseButton;
	TQPixmap               m_pixSystemIcon;
public:
	int heightHint();
	void setActive(bool bActive);
	bool active(){ return m_bActive; };
	void setSystemIcon(const TQPixmap &pix){ m_pSystemButton->setPixmap(pix); m_pixSystemIcon = pix; };
	const TQPixmap * systemIcon(){ return &m_pixSystemIcon; };
	void enableClose(bool bEnable){ m_pCloseButton->setEnabled(bEnable); };
	bool closeEnabled(){ return m_pCloseButton->isEnabled(); };
	virtual void setFocusProxy(TQWidget * w);
protected:
	void calcLineSpacing();
	virtual void fontChange(const TQFont &old);
	virtual void mousePressEvent(TQMouseEvent *e);
	virtual void mouseDoubleClickEvent(TQMouseEvent *e);
	virtual void mouseMoveEvent(TQMouseEvent *e);
	virtual void mouseReleaseEvent(TQMouseEvent *e);
	virtual void paintEvent(TQPaintEvent * e);
	virtual void resizeEvent(TQResizeEvent * e);
	void reloadImages();
};


#endif //_KVI_MDICAPTION_H_
