###########################################
#                                         #
#  Improvements and feedback are welcome  #
#                                         #
#  This file is released under GPL >= 3   #
#                                         #
###########################################


# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_architecture_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


##### check for libkonq

if( WITH_KONQUEROR )
  find_file( HAVE_LIBKONQ "konq_popupmenu.h" "konqbookmarkmanager.h" )
  if( NOT HAVE_LIBKONQ )
    tde_message_fatal( "libkonq was requested, but not found on your system" )
  endif( )
endif( )


##### check for javascript

if( WITH_JAVASCRIPT )
  find_file( HAVE_JAVASCRIPT "kjsembed/kjsembedpart.h" )
  if( NOT HAVE_JAVASCRIPT )
    tde_message_fatal( "Embedded Javascript interpreter was requested, but not found on your system" )
  endif( )
endif( )


##### check for ACL

if( WITH_ACL )
  pkg_search_module( ACL libacl )
  if( NOT ACL_FOUND )
    tde_message_fatal( "ACL support was requested, but not found on your system" )
  endif( )
  set( HAVE_POSIX_ACL 1 )
  find_file( HAVE_NON_POSIX_ACL_EXT "acl/libacl.h" )
endif( )
