/* This file is part of the KDE libraries
    Copyright (C) 2000 Reginald Stadlbauer <reggie@kde.org>
    Copyright (C) 2002 Werner Trobin <trobin@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include <kcoloractions.h>

#include <tqpopupmenu.h>
#include <tqwhatsthis.h>
#include <tqtooltip.h>

#include <tdeapplication.h>
#include <tdetoolbar.h>
#include <tdetoolbarbutton.h>
#include <kdebug.h>

KColorAction::KColorAction( const TQString& text, int accel,
			    TQObject* parent, const char* name )
    : TDEAction( text, accel, parent, name )
{
    typ = TextColor;
    init();
}

KColorAction::KColorAction( const TQString& text, int accel,
			    TQObject* receiver, const char* slot, TQObject* parent,
			    const char* name )
    : TDEAction( text, accel, receiver, slot, parent, name )
{
    typ = TextColor;
    init();
}

KColorAction::KColorAction( const TQString& text, Type type, int accel,
			    TQObject* parent, const char* name )
    : TDEAction( text, accel, parent, name )
{
    typ = type;
    init();
}

KColorAction::KColorAction( const TQString& text, Type type, int accel,
			    TQObject* receiver, const char* slot, TQObject* parent,
			    const char* name )
    : TDEAction( text, accel, receiver, slot, parent, name )
{
    typ = type;
    init();
}

KColorAction::KColorAction( TQObject* parent, const char* name )
    : TDEAction( parent, name )
{
    typ = TextColor;
    init();
}

void KColorAction::setColor( const TQColor &c )
{
    if ( c == col )
	return;

    col = c;
    createPixmap();
}

TQColor KColorAction::color() const
{
    return col;
}

void KColorAction::setType( Type t )
{
    if ( t == typ )
	return;

    typ = t;
    createPixmap();
}

KColorAction::Type KColorAction::type() const
{
    return typ;
}

void KColorAction::init()
{
    col = TQt::black;
    createPixmap();
}

void KColorAction::createPixmap()
{
    int r, g, b;
    TQCString pix;
    TQCString line;

    col.rgb( &r, &g, &b );

    pix = "/* XPM */\n";

    pix += "static char * text_xpm[] = {\n";

    switch ( typ ) {
      case TextColor: {
        pix += "\"20 20 11 1\",\n";
        pix += "\"h c #c0c000\",\n";
        pix += "\"g c #808000\",\n";
        pix += "\"f c #c0c0ff\",\n";
        pix += "\"a c #000000\",\n";
        pix += "\"d c #ff8000\",\n";
        pix += "\". c none\",\n";
        pix += "\"e c #0000c0\",\n";
        pix += "\"i c #ffff00\",\n";
        line.sprintf( "\"# c #%02X%02X%02X \",\n", r, g, b );
        pix += line.copy();
        pix += "\"b c #c00000\",\n";
        pix += "\"c c #ff0000\",\n";
        pix += "\"....................\",\n";
        pix += "\"....................\",\n";
        pix += "\"....................\",\n";
        pix += "\"........#...........\",\n";
        pix += "\"........#a..........\",\n";
        pix += "\".......###..........\",\n";
        pix += "\".......###a.........\",\n";
        pix += "\"......##aa#.........\",\n";
        pix += "\"......##a.#a........\",\n";
        pix += "\".....##a...#........\",\n";
        pix += "\".....#######a.......\",\n";
        pix += "\"....##aaaaaa#.......\",\n";
        pix += "\"....##a.....aaaaaaaa\",\n";
        pix += "\"...####....#abbccdda\",\n";
        pix += "\"....aaaa....abbccdda\",\n";
        pix += "\"............aee##ffa\",\n";
        pix += "\"............aee##ffa\",\n";
        pix += "\"............agghhiia\",\n";
        pix += "\"............agghhiia\",\n";
        pix += "\"............aaaaaaaa\"};\n";
      } break;
      case FrameColor: {
	pix += "\" 20 20 3 1 \",\n";

	pix += "\"  c none \",\n";
	pix += "\"+ c white \",\n";
	line.sprintf( "\". c #%02X%02X%02X \",\n", r, g, b );
	pix += line.copy();

	pix += "\"                     \",\n";
	pix += "\"                     \",\n";
	pix += "\"  ................  \",\n";
	pix += "\"  ................  \",\n";
	pix += "\"  ................  \",\n";
	pix += "\"  ...++++++++++...  \",\n";
	pix += "\"  ...++++++++++...  \",\n";
	pix += "\"  ...++++++++++...  \",\n";
	pix += "\"  ...++++++++++...  \",\n";
	pix += "\"  ...++++++++++...  \",\n";
	pix += "\"  ...++++++++++...  \",\n";
	pix += "\"  ...++++++++++...  \",\n";
	pix += "\"  ...++++++++++...  \",\n";
	pix += "\"  ...++++++++++...  \",\n";
	pix += "\"  ...++++++++++...  \",\n";
	pix += "\"  ................  \",\n";
	pix += "\"  ................  \",\n";
	pix += "\"  ................  \",\n";
	pix += "\"                     \",\n";
	pix += "\"                     \";\n";
      } break;
      case BackgroundColor: {
        pix += "\" 20 20 3 1 \",\n";

        pix += "\"  c none \",\n";
        pix += "\". c red \",\n";
        line.sprintf( "\"+ c #%02X%02X%02X \",\n", r, g, b );
        pix += line.copy();

        pix += "\"                     \",\n";
        pix += "\"                     \",\n";
        pix += "\"  ................  \",\n";
        pix += "\"  ................  \",\n";
        pix += "\"  ..++++++++++++..  \",\n";
        pix += "\"  ..++++++++++++..  \",\n";
        pix += "\"  ..++++++++++++..  \",\n";
        pix += "\"  ..++++++++++++..  \",\n";
        pix += "\"  ..++++++++++++..  \",\n";
        pix += "\"  ..++++++++++++..  \",\n";
        pix += "\"  ..++++++++++++..  \",\n";
        pix += "\"  ..++++++++++++..  \",\n";
        pix += "\"  ..++++++++++++..  \",\n";
        pix += "\"  ..++++++++++++..  \",\n";
        pix += "\"  ..++++++++++++..  \",\n";
        pix += "\"  ..++++++++++++..  \",\n";
        pix += "\"  ................  \",\n";
        pix += "\"  ................  \",\n";
        pix += "\"                     \",\n";
        pix += "\"                     \";\n";
      } break;
    }

    TQPixmap pixmap( pix );
    setIconSet( TQIconSet( pixmap ) );
}


TDESelectColorAction::TDESelectColorAction( const TQString& text, Type type,
                                        const TQObject* receiver, const char* slot,
                                        TDEActionCollection* parent, const char* name ) :
    TDEAction( text, TDEShortcut(), receiver, slot, parent, name ), m_type( type ),
    m_color( TQt::black )
{
}

TDESelectColorAction::~TDESelectColorAction()
{
}

int TDESelectColorAction::plug( TQWidget* w, int index )
{
    if (w == 0) {
	kdWarning() << "TDESelectColorAction::plug called with 0 argument\n";
 	return -1;
    }
    if (tdeApp && !tdeApp->authorizeTDEAction(name()))
        return -1;

    if ( w->inherits("TQPopupMenu") )
    {
        TQPopupMenu* menu = static_cast<TQPopupMenu*>( w );
        int id;

        if ( hasIcon() )
        {
            /* ###### CHECK: We're not allowed to specify the instance in iconSet()
            TDEInstance *instance;
            if ( parentCollection() )
                instance = parentCollection()->instance();
            else
                instance = TDEGlobal::instance();
            */
            id = menu->insertItem( iconSet( TDEIcon::Small, 0 ), text(), this,//dsweet
                                   TQ_SLOT( slotActivated() ), 0, -1, index );
        }
        else
            id = menu->insertItem( text(), this, TQ_SLOT( slotActivated() ),  //dsweet
                                   0, -1, index );

        updateShortcut( menu, id );

        // call setItemEnabled only if the item really should be disabled,
        // because that method is slow and the item is per default enabled
        if ( !isEnabled() )
            menu->setItemEnabled( id, false );

        if ( !whatsThis().isEmpty() )
            menu->setWhatsThis( id, whatsThisWithIcon() );

        addContainer( menu, id );
        connect( menu, TQ_SIGNAL( destroyed() ), this, TQ_SLOT( slotDestroyed() ) );

        if ( parentCollection() )
            parentCollection()->connectHighlight( menu, this );

        return containerCount() - 1;
    }
    else if ( w->inherits( "TDEToolBar" ) )
    {
        TDEToolBar *bar = static_cast<TDEToolBar *>( w );

        int id_ = getToolButtonID();
        TDEInstance *instance;
        if ( parentCollection() )
            instance = parentCollection()->instance();
        else
            instance = TDEGlobal::instance();

        if ( icon().isEmpty() ) // old code using TQIconSet directly
        {
            bar->insertButton( iconSet( TDEIcon::Small ).pixmap(), id_, TQ_SIGNAL( clicked() ), this,
                               TQ_SLOT( slotActivated() ),
                               isEnabled(), plainText(), index );
        }
        else
            bar->insertButton( icon(), id_, TQ_SIGNAL( clicked() ), this,
                               TQ_SLOT( slotActivated() ),
                               isEnabled(), plainText(), index, instance );

        bar->getButton( id_ )->setName( TQCString("toolbutton_")+name() );

        if ( !whatsThis().isEmpty() )
            TQWhatsThis::add( bar->getButton(id_), whatsThisWithIcon() );

        if ( !toolTip().isEmpty() )
            TQToolTip::add( bar->getButton(id_), toolTip() );

        addContainer( bar, id_ );

        connect( bar, TQ_SIGNAL( destroyed() ), this, TQ_SLOT( slotDestroyed() ) );

        if ( parentCollection() )
            parentCollection()->connectHighlight( bar, this );

        return containerCount() - 1;
    }

    return -1;
}

TQColor TDESelectColorAction::color() const
{
    return m_color;
}

TDESelectColorAction::Type TDESelectColorAction::type() const
{
    return m_type;
}

void TDESelectColorAction::setColor( const TQColor &/*c*/ )
{
}

void TDESelectColorAction::setType( Type /*t*/ )
{
}

TQString TDESelectColorAction::whatsThisWithIcon() const
{
    TQString text = whatsThis();
    if (!icon().isEmpty())
      return TQString::fromLatin1("<img source=\"small|%1\"> %2").arg(icon()).arg(text);
    return text;
}

#include <kcoloractions.moc>
