#ifndef KSPREAD_HANDLER_H
#define KSPREAD_HANDLER_H

#include <KoContainerHandler.h>

#include <tqpoint.h>

#include <KoQueryTrader.h>

class TQWidget;

enum HandlerType
{
  Part,
  Chart,
  Picture
};

namespace KSpread
{
class View;

/**
 * This event handler is used to insert a new part. The event handler
 * takes care of selecting the rectangle at which the new
 * part will appear.
 */
class InsertHandler : public KoEventHandler
{
    TQ_OBJECT
  
public:
    InsertHandler( View* view, TQWidget* widget );
    ~InsertHandler();

    virtual HandlerType getType() = 0;

protected:
    bool eventFilter( TQObject*, TQEvent* );
    virtual void insertObject( TQRect ) = 0;

    View* m_view;
    TQPoint m_geometryStart;
    TQPoint m_geometryEnd;
    bool m_started;
    bool m_clicked;
};

class InsertPartHandler : public InsertHandler
{
  public:
    InsertPartHandler( View* view, TQWidget* widget, const KoDocumentEntry& entry );
    virtual ~InsertPartHandler();
    HandlerType getType() { return Part; }

  private:
    void insertObject( TQRect );

    KoDocumentEntry m_entry;
};


class InsertChartHandler : public InsertHandler
{
  public:
    InsertChartHandler( View* view, TQWidget* widget, const KoDocumentEntry& entry );
    virtual ~InsertChartHandler();
    HandlerType getType() { return Chart; }

  private:
    void insertObject( TQRect );

    KoDocumentEntry m_entry;
};

class InsertPictureHandler : public InsertHandler
{
  public:
    InsertPictureHandler( View* view, TQWidget* widget, const KURL &);
    virtual ~InsertPictureHandler();
    HandlerType getType() { return Picture; }

  private:
    void insertObject( TQRect );

    KURL m_file;
};

} // namespace KSpread

#endif
