/*
 * Kivio - Visual Modelling and Flowcharting
 * Copyright (C) 2000-2001 theKompany.com & Dave Marotti
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef KIVIO_STENCIL_SPAWNER_INFO_H
#define KIVIO_STENCIL_SPAWNER_INFO_H

#include <tqstring.h>
#include <koffice_export.h>
class TQDomElement;
class KIVIO_EXPORT KivioStencilSpawnerInfo
{
protected:
    TQString m_author,
       m_title,
       m_id,
       m_desc,
       m_version,
       m_web,
       m_email,
       m_autoUpdate;
        
public:
    KivioStencilSpawnerInfo();
    KivioStencilSpawnerInfo( const TQString &, const TQString &, const TQString &, const TQString &, const TQString &, const TQString &, const TQString &, const TQString & );
    virtual ~KivioStencilSpawnerInfo();
    
    bool loadXML( const TQDomElement & );
    
    
    TQString author()        { return m_author; }
    TQString title()         { return m_title; }
    TQString id()            { return m_id; }
    TQString desc()          { return m_desc; }
    TQString version()       { return m_version; }
    TQString web()           { return m_web; }
    TQString email()         { return m_email; }
    TQString autoUpdate()    { return m_autoUpdate; }
    
};

#endif


