/* This file is part of the KDE project
   Copyright (C) 2005 Jaroslaw Staniek <js@iidea.pl>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef TDELISTVIEWITEMTEMPLATE_H
#define TDELISTVIEWITEMTEMPLATE_H

#include <tdelistview.h>

//! TQListViewItem class with ability for storing additional data member
template<class type>
class TDEListViewItemTemplate : public TDEListViewItem
{
	public:
		TDEListViewItemTemplate(type _data, TQListView *parent)
		 : TDEListViewItem(parent), data(_data) {}
		TDEListViewItemTemplate(type _data, TQListViewItem *parent)
		 : TDEListViewItem(parent), data(_data) {}
		TDEListViewItemTemplate(type _data, TQListView *parent, TQListViewItem *after)
		 : TDEListViewItem(parent, after), data(_data) {}
		TDEListViewItemTemplate(type _data, TQListViewItem *parent, TQListViewItem *after)
		 : TDEListViewItem(parent, after), data(_data) {}
		TDEListViewItemTemplate(type _data, TQListView *parent, TQString label1, TQString label2=TQString(), TQString label3=TQString(), TQString label4=TQString(), TQString label5=TQString(), TQString label6=TQString(), TQString label7=TQString(), TQString label8=TQString())
		 : TDEListViewItem(parent, label1, label2, label3, label4, label5, label6, label7, label8), data(_data) {}
		TDEListViewItemTemplate(type _data, TQListViewItem *parent, TQString label1, TQString label2=TQString(), TQString label3=TQString(), TQString label4=TQString(), TQString label5=TQString(), TQString label6=TQString(), TQString label7=TQString(), TQString label8=TQString())
		 : TDEListViewItem(parent, label1, label2, label3, label4, label5, label6, label7, label8), data(_data) {}
		TDEListViewItemTemplate(type _data, TQListView *parent, TQListViewItem *after, TQString label1, TQString label2=TQString(), TQString label3=TQString(), TQString label4=TQString(), TQString label5=TQString(), TQString label6=TQString(), TQString label7=TQString(), TQString label8=TQString())
		 : TDEListViewItem(parent, after, label1, label2, label3, label4, label5, label6, label7, label8), data(_data) {}
		TDEListViewItemTemplate(type _data, TQListViewItem *parent, TQListViewItem *after, TQString label1, TQString label2=TQString(), TQString label3=TQString(), TQString label4=TQString(), TQString label5=TQString(), TQString label6=TQString(), TQString label7=TQString(), TQString label8=TQString())
		 : TDEListViewItem(parent, after, label1, label2, label3, label4, label5, label6, label7, label8), data(_data) {}
		
		type data;
};

#endif
