/*
 *  Copyright (c) 2005 Adrian Page
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef KIS_TOOL_SHAPE_H_
#define KIS_TOOL_SHAPE_H_

#include <koffice_export.h>

#include "kis_tool_paint.h"
#include "kis_painter.h"

class TQGridLayout;
class WdgGeometryOptions;

class KRITACORE_EXPORT KisToolShape : public KisToolPaint {

    TQ_OBJECT
  
    typedef KisToolPaint super;

public:
    KisToolShape(const TQString& UIName);
    virtual ~KisToolShape();

    virtual enumToolType toolType() { return TOOL_SHAPE; }

protected:
    virtual TQWidget* createOptionWidget(TQWidget* parent);

    KisPainter::FillStyle fillStyle();

private:
    TQGridLayout *m_optionLayout;
        WdgGeometryOptions *m_shapeOptionsWidget;
};

#endif // KIS_TOOL_SHAPE_H_

