/*
 * This file is part of Chalk
 *
 * Copyright (c) 2005 Boudewijn Rempt <boud@valdyas.org>
 * Copyright (c) 2007 Benjamin Schleimer <bensch128@yahoo.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef BUMPMAP_H
#define BUMPMAP_H

#include <tqwidget.h>

#include <tdeparts/plugin.h>

#include <kis_types.h>
#include <kis_filter.h>
#include "kis_filter_config_widget.h"

class WdgBumpMap;

namespace chalk {

    enum enumBumpmapType {
        LINEAR = 0,
        SPHERICAL = 1,
        SINUSOIDAL = 2
    };

}

using namespace chalk;



class ChalkBumpmap : public KParts::Plugin
{
public:
    ChalkBumpmap(TQObject *parent, const char *name, const TQStringList &);
    virtual ~ChalkBumpmap();
};


/**
 * First stab at a bumpmapping filter. For now, this is taken both
 * from the Gimp source and the code from emboss.c:
 *             ANSI C code from the article
 *             "Fast Embossing Effects on Raster Image Data"
 *             by John Schlag, jfs@kerner.com
 *             in "Graphics Gems IV", Academic Press, 1994
 */
class KisFilterBumpmap : public KisFilter
{
public:
    KisFilterBumpmap();
public:
    virtual void process(KisPaintDeviceSP src, KisPaintDeviceSP dst, KisFilterConfiguration*, const TQRect&);
    virtual ColorSpaceIndependence colorSpaceIndependence() { return TO_LAB16; };
    static inline KisID id() { return KisID("bumpmap", i18n("Bumpmap")); };
    virtual bool supportsPainting() { return true; }
    virtual bool supportsPreview() { return true; }
    virtual bool supportsIncrementalPainting() { return true; }
    virtual bool supportsAdjustmentLayers() { return false; }
    virtual bool supportsThreading() { return false; }

    virtual KisFilterConfigWidget * createConfigurationWidget(TQWidget* parent, KisPaintDeviceSP dev);
    virtual KisFilterConfiguration * configuration(TQWidget*);
    virtual KisFilterConfiguration * configuration();

};



class KisBumpmapConfiguration : public KisFilterConfiguration {

public:
    
    KisBumpmapConfiguration();
    virtual void fromXML( const TQString&  );
    virtual TQString toString();
    
public:

    TQString bumpmap;
    double  azimuth;
    double  elevation;
    double  depth;
    TQ_INT32 xofs;
    TQ_INT32 yofs;
    TQ_INT32 waterlevel;
    TQ_INT32 ambient;
    bool    compensate;
    bool    invert;
    bool    tiled;
    enumBumpmapType type;
        
};


class KisBumpmapConfigWidget : public KisFilterConfigWidget {

    TQ_OBJECT
  

public:
    KisBumpmapConfigWidget(KisFilter * filter, KisPaintDeviceSP dev, TQWidget * parent, const char * name = 0, WFlags f = 0 );
    virtual ~KisBumpmapConfigWidget() {};

    KisBumpmapConfiguration * config();
    void setConfiguration(KisFilterConfiguration * config);

private:

    WdgBumpmap * m_page;
};

#endif
