/***************************************************************************
 *                                                                         *
 *   Copyright (C) 2005, 2006 by Kevin Gilbert                             *
 *   kev.gilbert@cdu.edu.au                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 *                                                                         *
 ***************************************************************************/

#ifndef _SIMPLEOPTIONS_H_
#define _SIMPLEOPTIONS_H_

#ifdef HAVE_CONFIG_H
#	include <config.h>
#endif

#include <tqwidget.h>
#include "global.h"

//	forward class definitions
//	=========================

class TQCheckBox;
class TDEConfig;

//	SimpleOptions class definition
//	==============================

class SimpleOptions : public TQWidget
{	TQ_OBJECT

	public:
		SimpleOptions( TQWidget* parent, const char* name = NULL );

		void finaliseInitialisation( );
		bool getOptions( bool& needRoot );
		void readProfile( TDEConfig* config );
		void saveProfile( TDEConfig* config );
		void setInitialValues( );

		bool allPortsState( )       const { return m_allPortsState;       }
		bool fastScanState( )       const { return m_fastScanState;       }
		bool ipV6State( )           const { return m_ipV6State;           }
		bool noRandomPortsState( )  const { return m_noRandomPortsState;  }
		bool osDetectionState( )    const { return m_osDetectionState;    }
		bool osScanLimitState( )    const { return m_osScanLimitState;    }
		bool packetTraceState( )    const { return m_packetTraceState;    }
		bool prepackagedState( )    const { return m_prepackagedState;     }
		bool privilegedState( )     const { return m_privilegedState;     }
		bool randomizeHostsState( ) const { return m_randomizeHostsState; }
		bool sendEthState( )        const { return m_sendEthState;        }
		bool sendIPState( )         const { return m_sendIPState;         }
		bool verboseState( )        const { return m_verboseState;        }

	signals:
		void disablePortRanges( );
		void displayDocBook( const TQString& );
		void displayHelp( const TQString& );
		void displayUnknown( );
		void optionsDirty( );

	public slots:
		void slotDisableFastScan( );

	private slots:
		void slotFastScanCheckBoxClicked( );
		void slotWhatsThisClicked( );

	private:
		void createLayout( );

		TQCheckBox* m_allPortsCheckBox;
		bool       m_allPortsState;
		TQCheckBox* m_fastScanCheckBox;
		bool       m_fastScanState;
		TQCheckBox* m_ipV6CheckBox;
		bool       m_ipV6State;
		TQCheckBox* m_noRandomPortsCheckBox;
		bool       m_noRandomPortsState;
		TQCheckBox* m_osDetectionCheckBox;
		bool       m_osDetectionState;
		TQCheckBox* m_osScanLimitCheckBox;
		bool       m_osScanLimitState;
		TQCheckBox* m_packetTraceCheckBox;
		bool       m_packetTraceState;
		TQCheckBox* m_prepackagedCheckBox;
		bool       m_prepackagedState;
		TQCheckBox* m_privilegedCheckBox;
		bool       m_privilegedState;
		TQCheckBox* m_randomizeHostsCheckBox;
		bool       m_randomizeHostsState;
		TQCheckBox* m_sendEthCheckBox;
		bool       m_sendEthState;
		TQCheckBox* m_sendIPCheckBox;
		bool       m_sendIPState;
		TQCheckBox* m_verboseCheckBox;
		bool       m_verboseState;
};

#endif	// _SIMPLEOPTIONS_H_
