
/***************************************************************************
 *                                                                         *
 *   KCPULoad and KNetLoad are copyright (c) 1999-2000, Markus Gustavsson  *
 *                                       (c) 2002, Ben Burton              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ICONTOGGLEACTION_H
#define __ICONTOGGLEACTION_H

#include <tdeaction.h>

/**
 * A toggle action that uses different labels and pixmaps in its
 * different states.
 */
class IconToggleAction : public TDEToggleAction {
    TQ_OBJECT
  

    public:
        /**
         * Constructors.
         */
        IconToggleAction(
            const TQString& useTextUnchecked, const TQString& useIconUnchecked,
            const TQString& useTextChecked, const TQString& useIconChecked,
            const TDEShortcut& cut, const TQObject* receiver, const char* slot,
            TQObject* parent, const char* name = 0);
        IconToggleAction(const TQString& useText,
            const TQString& useIconUnchecked, const TQString& useIconChecked,
            const TDEShortcut& cut, const TQObject* receiver, const char* slot,
            TQObject* parent, const char* name = 0);
        IconToggleAction(
            const TQString& useTextUnchecked, const TQString& useIconUnchecked,
            const TQString& useTextChecked, const TQString& useIconChecked,
            const TDEShortcut& cut = TDEShortcut(), TQObject* parent = 0,
            const char* name = 0);
        IconToggleAction(const TQString& useText,
            const TQString& useIconUnchecked, const TQString& useIconChecked,
            const TDEShortcut& cut = TDEShortcut(), TQObject* parent = 0,
            const char* name = 0);

        /**
         * Overridden to include icon adjustment.
         */
        virtual void setChecked(bool);

    private:
        TQString textChecked, textUnchecked;
            /**< The labels to use in the checked and unchecked states. */
        TQString iconChecked, iconUnchecked;
            /**< The icons to use in the checked and unchecked states. */
};

#endif
