//
// C++ Implementation: kmfrulesetdoc
//
// Description: 
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kmfrulesetdoc.h"


// TQt includes
#include <tqfile.h>
#include <tqdom.h>


// KDE includes
#include <tdelocale.h>
#include <kdebug.h>

// Project Inclueds
#include "kmftarget.h"
#include "kmftargetconfig.h"
#include "kmfnetwork.h"
#include "kmfundoengine.h"
#include "kmferror.h"

namespace KMF {

KMFRulesetDoc::KMFRulesetDoc( KMFTarget* target )
{
	kdDebug() << "KMFRulesetDoc::KMFRulesetDoc( KMFTarget* target )" << endl;
	
	setTarget( target );
}


KMFRulesetDoc::~KMFRulesetDoc()
{
}

KMFTarget* KMFRulesetDoc::target() {
	return m_target;
}

void KMFRulesetDoc::setTarget( KMFTarget* target ) {
	m_target = target;
}

KMFNetwork* KMFRulesetDoc::network(){
	if ( ! m_target ) {
		kdDebug() << "ERROR: network() - target == 0 " <<  endl;
		return 0;
	}
	KMFNetwork *n = target()->network();
	if ( ! n ) {
		kdDebug() << "ERROR: network() - target()->network() == 0 " <<  endl;
		return 0;
	}
	return n;
}

KMFError* KMFRulesetDoc::createFirewallScript( const TQString& fi ) {
	KMFError* m_err = new KMFError();
	TQString file;
	file = fi;
	if ( file.isEmpty() ) {
		kdDebug() << "Cant open output file" << endl;
		m_err->setErrType( KMFError::NORMAL );
		const TQString& msg = i18n( "Opening file for writing failed.\n"
		                           "Please make sure that you are logged in as root." );
		m_err->setErrMsg( msg );
		return m_err;

	}

	TQFile f( file );
	f.remove();
	bool gotit = f.open( IO_ReadWrite );
	if ( ! gotit ) {
		m_err->setErrType( KMFError::NORMAL );
		const TQString& msg = i18n( "Opening file for writing failed.\n"
		                           "Please make sure that you are logged in as root." );
		m_err->setErrMsg( msg );
		return m_err;
	}

	TQTextStream ts( &f );
	TQString s;
	kdDebug() << "########### start compiling ###########" << endl;
	ts << compile() << endl;
	kdDebug() << "########### Finished compiling ###########" << endl;
	f.flush();
	f.close();
	m_err->setErrType( KMFError::OK );
	const TQString& msg = "";
	m_err->setErrMsg( msg );
	return m_err;
}

}
