/***************************************************************************
   begin                : Fri Feb 21 2003
   copyright            : (C) 2003 by Christian Hubinger
   email                : chubinger@irrsinnig.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


// TQt includes
#include <tqlabel.h>
#include <tqpainter.h>
#include <tqfont.h>
#include <tqwidget.h>

// KDE includes
#include <tdestandarddirs.h>
#include <kdebug.h>
#include <tdeglobalsettings.h>
#include <kurl.h>
#include <tdefiledialog.h>
// Project includes
#include "kmfapp.h"
#include "../version.h"


namespace KMF {

KMFApp::KMFApp() {}
KMFApp::~KMFApp() {}

static TQLabel *splash = 0;

void set_splash_status( const TQString& msg ) {
	if ( !splash )
		return ;
	splash->repaint( false );
	TQPainter p( splash );
	TQFont f( TDEGlobalSettings::generalFont().family(), 8, TQFont::Bold );
	p.setFont( f );
	p.setPen( TQt::white );
	p.drawText( splash->width() / 2 - splash->fontMetrics().width( msg ) / 2, 265, msg );
	TQApplication::flush();
}

void showSplash() {
	TQRect screen = TQApplication::desktop() ->screenGeometry();
	TQRect mainRect;
	screen = TQApplication::desktop() ->screenGeometry( TQApplication::desktop() ->screenNumber( mainRect.center() ) );

	bool show = true;
	if ( show ) {
		TDEStandardDirs std_dir;
		TQString dir = std_dir.findResource( "data", "kmyfirewall/pics/splash.png" );
		kdDebug() << "\nFound Splashscreen at: " << dir << endl;

		TQPixmap pic = TQPixmap::fromMimeSource( dir );
		TQFont f( TDEGlobalSettings::generalFont().family(), 8, TQFont::Bold );
		if ( pic.isNull() )
			return ;
		TQPainter p( &pic );
		p.setFont( f );
		p.setPen( TQt::white );
		p.drawText( 280, 93, TQString( "Version %1" ).arg( KMYFIREWALL_VERSION ) );
		splash = new TQLabel( 0, "splash", TQWidget::WDestructiveClose | TQWidget::WStyle_Customize | TQWidget::WStyle_NoBorder | TQWidget::WX11BypassWM | TQWidget::WStyle_StaysOnTop );
		splash->setFrameStyle( TQFrame::WinPanel | TQFrame::Raised );
		splash->setPixmap( pic );
		splash->adjustSize();
		splash->setFixedSize( splash->sizeHint() );
		splash->move( screen.center() - TQPoint( splash->width() / 2, splash->height() / 2 ) );
		splash->repaint( false );
		splash->show();
		set_splash_status( "Initializing..." );
		TQApplication::flush();
	}
}

void closeSplash() {
	if ( splash ) {
		splash->close();
		splash = 0;
	}
}

}

