/***************************************************************************
*   Copyright (C) 2004-2006 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef BIBTEXFILEEXPORTERTOOLCHAIN_H
#define BIBTEXFILEEXPORTERTOOLCHAIN_H

#include "fileexporter.h"

class TQString;
class TQWaitCondition;
class TQProcess;
class TQStringList;

namespace BibTeX
{

    /**
    @author Thomas Fischer
    */
    class FileExporterToolchain : public FileExporter
    {
        TQ_OBJECT
    public:
        FileExporterToolchain();
        ~FileExporterToolchain();

    public slots:
        void cancel();

    protected:
        TQString workingDir;

        bool runProcesses( const TQStringList &progs, TQStringList *errorLog = NULL );
        bool runProcess( const TQStringList &args, TQStringList *errorLog = NULL );
        bool writeFileToIODevice( const TQString &filename, TQIODevice *device );
        bool kpsewhich( const TQString& filename );

    private:
        TQWaitCondition *m_waitCond;
        TQProcess *m_process;
        TQStringList *m_errorLog;

        TQString createTempDir();
        void deleteTempDir( const TQString& directory );

    private slots:
        void slotProcessExited();
        void slotReadProcessOutput();

    };

}

#endif
