/***************************************************************************
 *   Copyright (C) 2005 by Joe Ferris                                      *
 *   jferris@optimistictech.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include <kiconloader.h>
#include <tdeglobal.h>

#include <tqpixmap.h>

#include "mozillabookmark.h"

MozillaBookmark::MozillaBookmark(TQString _url, TQString _title, TQPixmap _icon)
 : KatapultItem()
{
	this->_url = _url;
	this->_icon = _icon;
	this->_title = _title;
}

TQPixmap MozillaBookmark::icon(int size) const
{
	return TDEGlobal::iconLoader()->loadIcon("bookmark", TDEIcon::NoGroup, size);
}

TQString MozillaBookmark::url() const
{
	return _url;
}

TQString MozillaBookmark::text() const
{
	return _title;
}

#include "mozillabookmark.moc"
