/*
Gwenview - A simple image viewer for TDE
Copyright 2000-2004 Aurlien Gteau

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/
#include "bookmarkdialog.moc"
// TQt
#include <tqlabel.h>

// KDE
#include <tdefile.h>
#include <kicondialog.h>
#include <klineedit.h>
#include <tdelocale.h>
#include <kurlrequester.h>

// Local
#include "bookmarkdialogbase.h"
namespace Gwenview {

class BookmarkDialogPrivate {
public:
	BookmarkDialogBase* mContent;
	BookmarkDialog::Mode mMode;
};

BookmarkDialog::BookmarkDialog(TQWidget* parent, BookmarkDialog::Mode mode)
: KDialogBase(parent,"folderconfig",true,TQString(),Ok|Cancel)
{
	d=new BookmarkDialogPrivate;
	d->mContent=new BookmarkDialogBase(this);
	d->mMode=mode;

	setMainWidget(d->mContent);
	setCaption(d->mContent->caption());
	d->mContent->mUrl->setMode(KFile::Directory);
	d->mContent->mIcon->setIcon("folder");
	
	connect(d->mContent->mTitle,TQ_SIGNAL(textChanged(const TQString&)),
		this, TQ_SLOT(updateOk()));
	connect(d->mContent->mIcon,TQ_SIGNAL(iconChanged(TQString)),
		this, TQ_SLOT(updateOk()));
	
	if (mode==BOOKMARK_GROUP) {
		d->mContent->mUrlLabel->hide();
		d->mContent->mUrl->hide();
	} else {
		connect(d->mContent->mUrl,TQ_SIGNAL(textChanged(const TQString&)),
			this, TQ_SLOT(updateOk()));
	}

	switch (mode) {
	case BOOKMARK_GROUP:
		setCaption( i18n("Add/Edit Bookmark Folder") );
		break;
	case BOOKMARK:
		setCaption( i18n("Add/Edit Bookmark") );
		break;
	}

	updateOk();
}

BookmarkDialog::~BookmarkDialog() {
	delete d;
}

void BookmarkDialog::updateOk() {
	bool enabled=
		!d->mContent->mTitle->text().isEmpty()
		&& (d->mMode==BOOKMARK_GROUP || !d->mContent->mUrl->url().isEmpty());

	enableButton(Ok, enabled);
}

void BookmarkDialog::setIcon(const TQString& icon) {
	d->mContent->mIcon->setIcon(icon);
}

TQString BookmarkDialog::icon() const {
	return d->mContent->mIcon->icon();
}

void BookmarkDialog::setTitle(const TQString& title) {
	d->mContent->mTitle->setText(title);
}

TQString BookmarkDialog::title() const {
	return d->mContent->mTitle->text();
}

void BookmarkDialog::setURL(const TQString& url) {
	d->mContent->mUrl->setURL(url);
}

TQString BookmarkDialog::url() const {
	return d->mContent->mUrl->url();
}

} // namespace
