###########################################
#                                         #
#  Improvements and feedback are welcome  #
#                                         #
#  This file is released under GPL >= 3   #
#                                         #
###########################################


# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_architecture_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )

set( ENV{PKG_CONFIG_PATH} "${PKG_CONFIG_PATH}:$ENV{PKG_CONFIG_PATH}:${LIB_INSTALL_DIR}/pkgconfig" )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


##### check for libexiv2

pkg_search_module( EXIV2 exiv2 )
if( NOT EXIV2_FOUND )
   tde_message_fatal( "exiv2 is required, but was not found on your system" )
endif( NOT EXIV2_FOUND )

check_include_file_cxx( "exiv2/exiv2.hpp" HAVE_EXIV2_EXIV2_HPP )


##### check for libjpeg

find_package( JPEG )
if( NOT JPEG_FOUND )
  tde_message_fatal( "jpeg library is required, but was not found on your system" )
endif()


##### checks for libkipi

if( WITH_KIPI )
  pkg_search_module( LIBKIPI libkipi )
  if( NOT LIBKIPI_FOUND )
    tde_message_fatal( "libkipi was requested but not found on your system." )
  endif( )
  set( GV_HAVE_KIPI 1 )
endif( )


##### checks for libmng

if( WITH_MNG )
  find_file( HAVE_LIBMNG_H "libmng.h" )
  if( NOT HAVE_LIBMNG_H )
    tde_message_fatal( "libmng was requested but not found on your system." )
  endif( )
  set( MNG_LIBRARY mng )
  set( HAVE_LIBMNG 1 )
endif( )


##### check for libpng

find_package( PNG )
if( NOT PNG_FOUND )
  tde_message_fatal( "png library is required, but was not found on your system" )
endif()


##### check for libxcursor
if( WITH_XCURSOR )
  pkg_search_module( XCURSOR xcursor )
  if( XCURSOR_FOUND )
    set( GV_HAVE_XCURSOR 1 )
  else( )
    tde_message_fatal( "xcursor library is required, but was not found on your system" )
  endif( )
endif()


##### check for lround function

tde_save_and_set( CMAKE_REQUIRED_LIBRARIES "m" )
check_symbol_exists ( lround  "math.h" HAVE_LROUND  )
tde_restore( CMAKE_REQUIRED_LIBRARIES )
if( NOT HAVE_LROUND )
  set( HAVE_LROUND 0 )
endif( NOT HAVE_LROUND )


##### check for thread support

find_package( Threads )


##### check specific architecture dependant support

if( CMAKE_SYSTEM_PROCESSOR MATCHES "i.86" )

  # MMX support
  message( STATUS "Performing MMX support test" )
  cmake_host_system_information( RESULT HAVE_X86_MMX QUERY HAS_MMX )
  if( HAVE_X86_MMX )
    message( STATUS "Performing MMX support test - Success" )
    set( CMAKE_ASM_FLAGS "${CMAKE_ASM_FLAGS} -DHAVE_X86_MMX" )
  endif( )

endif( )
