/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2003-01-21
 * Description : Gphoto2 camera interface
 * 
 * Copyright (C) 2003-2005 by Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Copyright (C) 2006-2007 by Gilles Caulier <caulier dot gilles at gmail dot com> 
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

#ifndef GPCAMERA_H
#define GPCAMERA_H

// Local includes.

#include "dkcamera.h"

class TQImage;

namespace Digikam
{

class GPCameraPrivate;
class GPStatus;

// Gphoto2 camera Implementation of abstract type DKCamera

class GPCamera : public DKCamera
{

public:

    GPCamera(const TQString& title, const TQString& model,
             const TQString& port, const TQString& path);
    ~GPCamera();

    bool thumbnailSupport();
    bool deleteSupport();
    bool uploadSupport();
    bool mkDirSupport();
    bool delDirSupport();

    bool doConnect();

    void cancel();

    void getAllFolders(const TQString& folder, TQStringList& subFolderList);
    bool getSubFolders(const TQString& folder, TQStringList& subFolderList);
    bool getItemsList(const TQString& folder, TQStringList& itemsList);
    bool getItemsInfoList(const TQString& folder, GPItemInfoList& items, bool getImageDimensions = true);
    bool getThumbnail(const TQString& folder, const TQString& itemName, TQImage& thumbnail);
    bool getExif(const TQString& folder, const TQString& itemName, char **edata, int& esize);

    bool setLockItem(const TQString& folder, const TQString& itemName, bool lock);

    bool downloadItem(const TQString& folder, const TQString& itemName, const TQString& saveFile);
    bool deleteItem(const TQString& folder, const TQString& itemName);

    // recursively delete all items
    bool deleteAllItems(const TQString& folder);

    bool uploadItem(const TQString& folder, const TQString& itemName, const TQString& localFile,
                    GPItemInfo& itemInfo, bool getImageDimensions=true);

    bool cameraSummary(TQString& summary);
    bool cameraManual(TQString& manual);
    bool cameraAbout(TQString& about);

    TQString model() const;
    TQString port()  const;
    TQString path()  const;
    
    // Public static methods shared with Camera Setup
    
    static int  autoDetect(TQString& model, TQString& port);
    static void getSupportedCameras(int& count, TQStringList& clist);
    static void getSupportedPorts(TQStringList& plist);
    static void getCameraSupportedPorts(const TQString& model, TQStringList& plist);

private:

    int setup();
    static void printGphotoErrorDescription(int errorCode);

private:

    GPCameraPrivate *d;
    GPStatus        *m_status;
};

}  // namespace Digikam

#endif /* GPCAMERA_H */
