/*********
*
* This file is part of BibleTime's source code, http://www.bibletime.info/.
*
* Copyright 1999-2006 by the BibleTime developers.
* The BibleTime source code is licensed under the GNU General Public License version 2.0.
*
**********/



#ifndef COPTIONSDIALOG_H
#define COPTIONSDIALOG_H

#include "cprofilemgr.h"
#include "cbtconfig.h"
#include "util/cpointers.h"

//TQt includes
#include <tqwidget.h>
#include <tqframe.h>
#include <tqguardedptr.h>
#include <tqlabel.h>
#include <tqstring.h>
#include <tqmap.h>
#include <tqdict.h>
#include <tqmap.h>

//TDE includes
#include <kdialogbase.h>
#include <tdefontdialog.h>
#include <tdeaccel.h>
#include <kcolorbutton.h>
#include <tdelocale.h>

class TQHBox;
class TQCheckBox;
class TQComboBox;
class TQRadioButton;
class TQWidgetStack;

class TDEListBox;
class KKeyChooser;
class KTabCtl;
class TDEHTMLPart;
class TDEActionCollection;

/**
 * The optionsdialog of BibleTime
  * @author The BibleTime Team
  */
class COptionsDialog : public KDialogBase, public CPointers  {
	TQ_OBJECT
  

public:
	COptionsDialog(TQWidget *parent, const char *name, TDEActionCollection* actionCollection);
	virtual ~COptionsDialog();

	enum Parts {
		Startup,
		Font,
		DisplayTemplates,
		Desk,
		Hotkeys
	};

	/** Opens the page which contaisn the given part ID. */
	const bool showPart( COptionsDialog::Parts ID );

private:
	struct Settings {
		struct StartupSettings {
			TQCheckBox* showTips;
			TQCheckBox* showLogo;
		}
		startup;

		struct SwordSettings {
			TQComboBox* standardBible;
			TQComboBox* standardCommentary;
			TQComboBox* standardLexicon;
			TQComboBox* standardDailyDevotional;
			TQComboBox* standardHebrewStrong;
			TQComboBox* standardGreekStrong;
			TQComboBox* standardHebrewMorph;
			TQComboBox* standardGreekMorph;
			TQCheckBox* lineBreaks;
			TQCheckBox* verseNumbers;
			TQCheckBox* headings;
			TQCheckBox* hebrewPoints;
			TQCheckBox* hebrewCantillation;
			TQCheckBox* morphSegmentation;
			TQCheckBox* greekAccents;
			TQCheckBox* textualVariants;
			TQCheckBox* scriptureReferences;
		}
		swords; // not: sword instead of sword -> namespace error

		struct KeySettings {
			TQComboBox* typeChooser;
			TQWidgetStack* keyChooserStack;

			struct WindowType {
				TQGuardedPtr<KKeyChooser> keyChooser;
				TDEActionCollection* actionCollection;
				TQString title;

				WindowType() {
					keyChooser = 0;
					actionCollection = 0;
				};
				WindowType(const TQString& newTitle) {
					title = newTitle;

					keyChooser = 0;
					actionCollection = 0;
				}
			};

			WindowType application;
			WindowType general;
			WindowType bible;
			WindowType commentary;
			WindowType lexicon;
			WindowType book;
		}
		keys;

		struct DisplayStyleSettings {
			TQComboBox* styleChooser;
			TDEHTMLPart* stylePreview;
		}
		displayStyle;

		struct FontSettings {
			TQComboBox* swordLocaleCombo;
			TDEFontChooser* fontChooser;
			TQComboBox* usage;
			TQCheckBox* useOwnFontBox;
			//the pair os to check whether the standard font (bool == false) or whether an own font should be used (true)
			TQMap<TQString,CBTConfig::FontSettingsPair> fontMap;
		}
		fonts;
	}
	m_settings;

protected slots: // Protected slots
	/**
	* Called when a new font in the fonts page was selected.
	*/
	void newDisplayWindowFontSelected(const TQFont &);
	/**
	* Called when the combobox contents is changed
	*/
	void newDisplayWindowFontAreaSelected(const TQString&);
	/**
	* Called if the OK button was clicked
	*/
	void slotOk();
	/**
	* Called if the Apply button was clicked
	* commented out for the time being.  ck
	*/
	void slotApply();
	/**
	* This slot is called when the "Use own font for language" bo was clicked.
	*/
	void useOwnFontClicked(bool);
	/**
	* Update the style preview widget
	*/
	void updateStylePreview();
	/**
	* The type of the keyaccel area changed
	*/
	void slotKeyChooserTypeChanged(const TQString&);

protected: // Protected methods
	/**
	* Initializes the startup section of the OD.
	*/
	void initDisplay();
	/**
	* Init Sword section.
	*/
	void initSword();
	/**
	* Init accel key section.
	*/
	void initAccelerators();
	/**
	* Init fonts section.
	*/
	void initLanguages();

	/** Save the display settings.
	*/
	void saveDisplay();
	/** Save the key accel settings.
	*/
	void saveAccelerators();
	/** Save the font settings.
	*/
	void saveLanguages();
	/** Save the Sword specific settings.
	*/
	void saveSword();

signals: // Signals
	void signalSettingsChanged();
};

#endif
