

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*  This code generated by:
 *      Author : thomas
 *      Date   : Tue Aug 19 2003
 */

#ifndef OWNEDCODEBLOCK_H
#define OWNEDCODEBLOCK_H

#include <tqdom.h>
#include <tqstring.h>
#include <tqobject.h>

class TextBlock;
class CodeDocument;
// class CodeGenObjectWithTextBlocks;
class UMLObject;

/**
  * class OwnedCodeBlock
  * Describes any codeblock which is 'owned' by a UMLobject of some sort and should
  * be in sync with that parent.
  */

class OwnedCodeBlock : virtual public TQObject
{
    TQ_OBJECT
  
public:

    // Constructors/Destructors
    //

    /**
     * Constructor
     */
    OwnedCodeBlock ( UMLObject * parent );

    /**
     * Empty Destructor
     */
    virtual ~OwnedCodeBlock ( );

    /**
     * @return  UMLObject
     */
    UMLObject * getParentObject ( );

    // get the parent code document of this code block
    virtual CodeDocument * getParentDocument ( ) = 0;

protected:

    /** causes the text block to release all of its connections
      * and any other text blocks that it 'owns'.
      * needed to be called prior to deletion of the textblock.
      */
    virtual void release ();

    /** set attributes of the node that represents this class
     * in the XMI document.
     */
    virtual void setAttributesOnNode ( TQDomDocument & doc, TQDomElement & blockElement);

    /** set the class attributes of this object from
     * the passed element node.
     */
    virtual void setAttributesFromNode ( TQDomElement & element);

    /** set the class attributes from a passed object
            */
    virtual void setAttributesFromObject (TextBlock * obj);

    /**
            * This is the method called from within syncToParent
     */
    virtual void updateContent ( ) = 0;

private:

    void initFields ( UMLObject * parent );

    UMLObject * m_parentObject;

public slots:

    virtual void syncToParent ( );

};

#endif // OWNEDCODEBLOCK_H
