/***************************************************************************
    begin                : Tue Mar 11 19:00:00 CET 2003
    copyright            : (C) 2003 by Stefan Asserhall
    email                : stefan.asserhall@telia.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "keydialog.h"

#include <tdeconfig.h>
#include <tdelocale.h>

#include <tqradiobutton.h>
#include <tqvbox.h>
#include <tqwhatsthis.h>


// Table of shortcut keys for each action, key group and three or four button modifier

const KeyDialog::KeyInfo KeyDialog::keyInfo[] = {
    { "PlayPause",
      { { TDEShortcut::null(),                        TDEShortcut::null() },
        { TQt::CTRL+TQt::ALT+TQt::Key_P,               KKey::QtWIN+TQt::ALT+TQt::Key_P },
        { TQt::Key_MediaPlay,                        TQt::Key_MediaPlay } } },
    { "Stop",
      { { TDEShortcut::null(),                        TDEShortcut::null() },
        { TQt::CTRL+TQt::ALT+TQt::Key_S,               KKey::QtWIN+TQt::ALT+TQt::Key_S },
        { TQt::Key_MediaStop,                        TQt::Key_MediaStop } } },
    { "Back",
      { { TDEShortcut::null(),                        TDEShortcut::null() },
        { TQt::CTRL+TQt::ALT+TQt::Key_Left,            KKey::QtWIN+TQt::ALT+TQt::Key_Left },
        { TQt::Key_MediaPrev,                        TQt::Key_MediaPrev } } },
    { "Forward",
      { { TDEShortcut::null(),                        TDEShortcut::null() },
        { TQt::CTRL+TQt::ALT+TQt::Key_Right,           KKey::QtWIN+TQt::ALT+TQt::Key_Right },
        { TQt::Key_MediaNext,                        TQt::Key_MediaNext } } },
    { "ForwardAlbum",
      { { TDEShortcut::null(),                        TDEShortcut::null() },
        { TQt::CTRL+TQt::ALT+TQt::Key_Up,              KKey::QtWIN+TQt::ALT+TQt::Key_Up },
        { TQt::CTRL+TQt::Key_MediaNext,               TQt::CTRL+TQt::Key_MediaNext } } },
    { "SeekBack",
      { { TDEShortcut::null(),                        TDEShortcut::null() },
        { TQt::CTRL+TQt::SHIFT+TQt::ALT+TQt::Key_Left,  KKey::QtWIN+TQt::SHIFT+TQt::ALT+TQt::Key_Left },
        { TQt::SHIFT+TQt::Key_MediaPrev,              TQt::SHIFT+TQt::Key_MediaPrev } } },
    { "SeekForward",
      { { TDEShortcut::null(),                        TDEShortcut::null() },
        { TQt::CTRL+TQt::SHIFT+TQt::ALT+TQt::Key_Right, KKey::QtWIN+TQt::SHIFT+TQt::ALT+TQt::Key_Right },
        { TQt::SHIFT+TQt::Key_MediaNext,              TQt::SHIFT+TQt::Key_MediaNext } } },
    { "VolumeUp",
      { { TDEShortcut::null(),                        TDEShortcut::null() },
        { TQt::CTRL+TQt::ALT+TQt::SHIFT+TQt::Key_Up,    KKey::QtWIN+TQt::ALT+TQt::SHIFT+TQt::Key_Up },
        { TQt::Key_VolumeUp,                         TQt::Key_VolumeUp } } },
    { "VolumeDown",
      { { TDEShortcut::null(),                        TDEShortcut::null() },
        { TQt::CTRL+TQt::ALT+TQt::SHIFT+TQt::Key_Down,  KKey::QtWIN+TQt::ALT+TQt::SHIFT+TQt::Key_Down },
        { TQt::Key_VolumeDown,                       TQt::Key_VolumeDown } } },
    { "Mute",
      { { TDEShortcut::null(),                        TDEShortcut::null() },
        { TQt::CTRL+TQt::ALT+TQt::Key_M,               KKey::QtWIN+TQt::ALT+TQt::Key_M },
        { TQt::Key_VolumeMute,                       TQt::Key_VolumeMute } } },
    { "ShowHide",
      { { TDEShortcut::null(),                        TDEShortcut::null() },
        { TDEShortcut::null(),                        TDEShortcut::null() },
        { TDEShortcut::null(),                        TDEShortcut::null() } } }
};

const uint KeyDialog::keyInfoCount = sizeof(KeyDialog::keyInfo) / sizeof(KeyDialog::keyInfo[0]);

KeyDialog::KeyDialog(TDEGlobalAccel *keys, TDEActionCollection *actionCollection,
                     TQWidget *parent, const char *name)
    : KDialogBase(parent, name, true, i18n("Configure Shortcuts"), Default | Ok | Cancel, Ok)
{
    // Read key group from configuration

    int selectedButton;

    TDEConfigGroup config(TDEGlobal::config(), "Shortcuts");
    selectedButton = config.readNumEntry("GlobalKeys", StandardKeys);

    // Create widgets for key chooser - widget stack used to replace key chooser

    TQVBox *vbox = new TQVBox(this);
    vbox->setSpacing(KDialog::spacingHint());
    m_widgetStack = new TQWidgetStack(vbox);

    vbox->setStretchFactor(m_widgetStack, 1);

    // Create buttons to select key group

    m_group = new TQHButtonGroup(i18n("Global Shortcuts"), vbox);
    new TQRadioButton(i18n("&No keys"), m_group);
    new TQRadioButton(i18n("&Standard keys"), m_group);
    new TQRadioButton(i18n("&Multimedia keys"), m_group);
    connect(m_group, TQ_SIGNAL(clicked(int)), this, TQ_SLOT(slotKeys(int)));
    TQWhatsThis::add(m_group,
      i18n("Here you can select the keys used as global shortcuts to control the player"));

    // Create the key chooser

    setMainWidget(vbox);
    newDialog(keys, actionCollection, selectedButton);
}

KeyDialog::~KeyDialog()
{

}

void KeyDialog::newDialog(TDEGlobalAccel *keys, TDEActionCollection *actionCollection,
                          int selectedButton)
{
    m_keys = keys;
    m_actionCollection = actionCollection;

    // Create key chooser and show it in the widget stack
    m_pKeyChooser = new KKeyChooser(keys, this);
    m_pKeyChooser->insert(actionCollection);
    m_widgetStack->addWidget(m_pKeyChooser);
    m_widgetStack->raiseWidget(m_pKeyChooser);
    m_group->setButton(selectedButton);

    connect(this, TQ_SIGNAL(defaultClicked()), this, TQ_SLOT(slotDefault()));
}

int KeyDialog::configure()
{
    // Show the dialog and save configuration if accepted

    int retcode = exec();
    if(retcode == Accepted) {

	TDEConfigGroup config(TDEGlobal::config(), "Shortcuts");
	config.writeEntry("GlobalKeys", m_group->id(m_group->selected()));
	TDEGlobal::config()->sync();

        m_pKeyChooser->save();
    }
    return retcode;
}

void KeyDialog::slotKeys(int group)
{
    bool fourModKeys = TDEGlobalAccel::useFourModifierKeys();

    // Set modifier keys according to key group and modifier keys

    for(uint i = 0; i < keyInfoCount; i++)
        m_keys->setShortcut(keyInfo[i].action, keyInfo[i].shortcut[group][fourModKeys]);

    // Create a new key chooser to show the keys, and delete the old one

    TQWidget *w = m_widgetStack->visibleWidget();
    newDialog(m_keys, m_actionCollection, group);
    m_widgetStack->removeWidget(w);
    delete w;
}

void KeyDialog::slotDefault()
{
    // Select default keys - standard key group

    m_group->setButton(StandardKeys);
    m_pKeyChooser->allDefault();
}

int KeyDialog::configure(TDEGlobalAccel *keys, TDEActionCollection *actionCollection,
                         TQWidget *parent)
{
    // Create and show dialog - update connections if accepted

    int retcode = KeyDialog(keys, actionCollection, parent).configure();

    if(retcode == Accepted)
        keys->updateConnections();
    return retcode;
}

void KeyDialog::insert(TDEGlobalAccel *keys, const TQString &action, const TQString &label,
                       const TQObject *objSlot, const char *methodSlot)
{
    TDEShortcut def3 = TDEShortcut::null();
    TDEShortcut def4 = TDEShortcut::null();

    // Find and insert a standard key

    for(uint i = 0; i < keyInfoCount; i++) {
        if(keyInfo[i].action == action) {
            def3 = keyInfo[i].shortcut[StandardKeys][0];
            def4 = keyInfo[i].shortcut[StandardKeys][1];
            break;
        }
    }
    keys->insert(action, label, TQString(), def3, def4, objSlot, methodSlot);
}

#include "keydialog.moc"
