/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_SEGMENTMMAPPERFACTORY_H_
#define _RG_SEGMENTMMAPPERFACTORY_H_



class TQString;


namespace Rosegarden
{

class TimeSigSegmentMmapper;
class TempoSegmentMmapper;
class SegmentMmapper;
class Segment;
class RosegardenGUIDoc;
class MetronomeMmapper;


class SegmentMmapperFactory
{
public:

    static SegmentMmapper* makeMmapperForSegment(RosegardenGUIDoc*, Segment*,
                                                 const TQString& fileName);

    static MetronomeMmapper*      makeMetronome(RosegardenGUIDoc*);
    static TimeSigSegmentMmapper* makeTimeSig(RosegardenGUIDoc*);
    static TempoSegmentMmapper*   makeTempo(RosegardenGUIDoc*);
};

//----------------------------------------



}

#endif
