/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_INSERTTRIGGERNOTECOMMAND_H_
#define _RG_INSERTTRIGGERNOTECOMMAND_H_

#include "base/NotationTypes.h"
#include "base/TriggerSegment.h"
#include "document/BasicCommand.h"
#include "gui/editors/notation/NoteStyle.h"
#include <string>
#include "base/Event.h"




namespace Rosegarden
{

class Segment;


class InsertTriggerNoteCommand : public BasicCommand
{
public:
    InsertTriggerNoteCommand(Segment &,
                             timeT time,
                             Note note,
                             int pitch,
                             int velocity,
                             NoteStyleName noteStyle,
                             TriggerSegmentId id,
                             bool retune,
                             std::string timeAdjust,
                             Mark mark);
    virtual ~InsertTriggerNoteCommand();

protected:
    virtual void modifySegment();

    timeT m_time;
    Note m_note;
    int m_pitch;
    int m_velocity;
    NoteStyleName m_noteStyle;
    TriggerSegmentId m_id;
    bool m_retune;
    std::string m_timeAdjust;
    Mark m_mark;
};



}

#endif
