/***************************************************************************
 *   Copyright (C) 2021 by Slávek Banko                                    *
 *                                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/

#if defined(HAVE_CONFIG_H)
#include "config.h"
#endif

#include <kgenericfactory.h>
#include <tdeaboutdata.h>

#include "otrplugin-factory.h"
#include "otrplugin.h"


// typedef KGenericFactory<OTRPlugin> OTRPluginFactory;
static const TDEAboutData aboutdata("kopete_otr", I18N_NOOP("OTR") , "0.7" );
K_EXPORT_COMPONENT_FACTORY( kopete_otr, OTRPluginFactory( &aboutdata )  )

TDEInstance *OTRPluginFactory::s_instance = 0;

OTRPluginFactory::OTRPluginFactory( const TDEAboutData *aboutdata )
{
    s_instance = new TDEInstance( aboutdata );
}

OTRPluginFactory::~OTRPluginFactory()
{
    delete s_instance;
}

KParts::Part *OTRPluginFactory::createPartObject( TQWidget * /*parentWidget*/,
                                                  const char * /*widgetName*/,
                                                  TQObject *parent,
                                                  const char *name,
                                                  const char * /*className*/,
                                                  const TQStringList & args )
{
    return (KParts::Part*) new OTRPlugin( instance(), parent, name, args);
}

#include "otrplugin-factory.moc"
