/* This file is part of the KDE project
   Copyright (C) 2004 Cedric Pasteur <cedric.pasteur@free.fr>
   Copyright (C) 2004  Alexander Dymo <cloudtemple@mskat.net>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include "coloredit.h"

#include <tqvariant.h>
#include <tqlayout.h>
#include <tqcolor.h>
#include <tqpainter.h>

#include <kcolorcombo.h>

using namespace KoProperty;

ColorButton::ColorButton(Property *property, TQWidget *parent, const char *name)
 : Widget(property, parent, name)
{
	TQHBoxLayout *l = new TQHBoxLayout(this, 0, 0);
	m_edit = new KColorCombo(this);
	m_edit->setFocusPolicy(TQWidget::NoFocus);
	connect(m_edit, TQ_SIGNAL(activated(int)), this, TQ_SLOT(slotValueChanged(int)));
	m_edit->setSizePolicy(TQSizePolicy::Expanding, TQSizePolicy::Expanding);
	m_edit->setMinimumHeight(5);
	l->addWidget(m_edit);
	setFocusWidget(m_edit);
}

ColorButton::~ColorButton()
{}

TQVariant
ColorButton::value() const
{
	return m_edit->color();
}

void
ColorButton::setValue(const TQVariant &value, bool emitChange)
{
	m_edit->blockSignals(true);
	m_edit->setColor(value.toColor());
	m_edit->blockSignals(false);
	if (emitChange)
		emit valueChanged(this);
}

void
ColorButton::drawViewer(TQPainter *p, const TQColorGroup &, const TQRect &r, const TQVariant &value)
{
	p->eraseRect(r);

	p->setBrush(value.toColor());
	p->setPen(TQt::SolidLine);
	TQRect r2(r);
	r2.setTopLeft(r.topLeft() + TQPoint(5,5));
	r2.setBottomRight(r.bottomRight() - TQPoint(5,5));
	p->drawRect(r2);
}

void
ColorButton::slotValueChanged(int)
{
	emit valueChanged(this);
}


bool
ColorButton::eventFilter(TQObject* watched, TQEvent* e)
{
	return Widget::eventFilter(watched, e);
}

void
ColorButton::setReadOnlyInternal(bool readOnly)
{
	setVisibleFlag(!readOnly);
}

#include "coloredit.moc"
