/* This file is part of the KDE project
   Copyright (C) 2002 Laurent MONTEL <lmontel@mandrakesoft.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include "KPrAutoFormObjectIface.h"
#include "KPrAutoformObject.h"
#include "KPrUtils.h"
#include "KPrObject.h"
#include <kdebug.h>

#include <tdeapplication.h>
#include <dcopclient.h>

KPrAutoFormObjectIface::KPrAutoFormObjectIface( KPrAutoformObject *_obj )
    : KPrObject2DIface(_obj)
{
    obj = _obj;
}

TQString KPrAutoFormObjectIface::fileName() const
{
    return obj->getFileName();
}

void KPrAutoFormObjectIface::setFileName( const TQString &_filename )
{
    obj->setFileName(_filename);
}

void KPrAutoFormObjectIface::setLineBegin( const TQString & type)
{
    obj->setLineBegin(lineEndBeginFromString( type ));
}

void KPrAutoFormObjectIface::setLineEnd( const TQString & type)
{
    obj->setLineEnd(lineEndBeginFromString( type ));
}
