/* This file is part of the KDE project
   Copyright (C) 1999,2000 Matthias Kalle Dalheimer <kalle@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/


#ifndef __KCHARTSUBTYPECHARTPAGE_H__
#define __KCHARTSUBTYPECHARTPAGE_H__

#include <tqwidget.h>

class KDChartParams;
class TQLabel;
class TQRadioButton;
class TQSpinBox;

namespace KChart
{

class KChartParams;

class KChartSubTypeChartPage : public TQWidget
{
    TQ_OBJECT
  

public:
    KChartSubTypeChartPage( KChartParams* params, TQWidget* parent ) :
        TQWidget( parent ), m_params( params ) {}
    virtual void init() = 0;
    virtual void apply() = 0;

protected:
    KChartParams* m_params;
};

class KChartLineSubTypeChartPage : public KChartSubTypeChartPage
{
    TQ_OBJECT
  

public:
    KChartLineSubTypeChartPage( KChartParams* params,
                                TQWidget* parent );
    virtual void init();
    virtual void apply();

private slots:
    void slotChangeSubType( int type );

private:
    TQRadioButton* normal;
    TQRadioButton* stacked;
    TQRadioButton* percent;
    TQLabel* exampleLA;
};


class KChartAreaSubTypeChartPage : public KChartSubTypeChartPage
{
    TQ_OBJECT
  

public:
    KChartAreaSubTypeChartPage( KChartParams* params,
                                TQWidget* parent );
    virtual void init();
    virtual void apply();

private slots:
    void slotChangeSubType( int type );

private:
    TQRadioButton* normal;
    TQRadioButton* stacked;
    TQRadioButton* percent;
    TQLabel* exampleLA;
};

class KChartBarSubTypeChartPage : public KChartSubTypeChartPage
{
    TQ_OBJECT
  

public:
    KChartBarSubTypeChartPage( KChartParams* params, TQWidget* parent );
    virtual void init();
    virtual void apply();

private slots:
    void slotChangeSubType( int type );

private:
    TQRadioButton  *normal;
    TQRadioButton  *stacked;
    TQRadioButton  *percent;
    TQLabel        *exampleLA;
    TQSpinBox      *m_numLines;
};


class KChartHiloSubTypeChartPage : public KChartSubTypeChartPage
{
    TQ_OBJECT
  

public:
    KChartHiloSubTypeChartPage( KChartParams* params,
                                TQWidget* parent );
    virtual void init();
    virtual void apply();

private slots:
    void slotChangeSubType( int type );

private:
    TQRadioButton* normal;
    TQRadioButton* stacked;
    TQRadioButton* percent;
    TQLabel* exampleLA;
};

class KChartPolarSubTypeChartPage : public KChartSubTypeChartPage
{
    TQ_OBJECT
  

public:
    KChartPolarSubTypeChartPage( KChartParams* params,
                                TQWidget* parent );
    virtual void init();
    virtual void apply();

private slots:
    void slotChangeSubType( int type );

private:
    TQRadioButton* normal;
    TQRadioButton* stacked;
    TQRadioButton* percent;
    TQLabel* exampleLA;
};

}  //KChart namespace

#endif
