/* ============================================================
 * File  : galleryviewitem.h
 * Author: Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Date  : 2004-12-01
 * Copyright 2004 by Renchi Raju <renchi@pooh.tam.uiuc.edu>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * ============================================================ */

#ifndef GALLERYVIEWITEM_H
#define GALLERYVIEWITEM_H

#include <tqlistview.h>

#include "galleryitem.h"

namespace KIPIGalleryExportPlugin
{

class GAlbumViewItem : public TQListViewItem
{
public:

    GAlbumViewItem(TQListView* parent, const TQString& name,
                   const GAlbum& _album)
        : TQListViewItem(parent, name), album(_album) {}
    GAlbumViewItem(TQListViewItem* parent, const TQString& name,
                   const GAlbum& _album)
        : TQListViewItem(parent, name), album(_album) {}

    GAlbum album;

    void paintCell(TQPainter * p, const TQColorGroup & cg,
                   int column, int width, int );
    void paintFocus (TQPainter*, const TQColorGroup&,
                     const TQRect&) {}

protected:

    void setup();
    
};

}

#endif /* GALLERYVIEWITEM_H */
