/*
 * This file is part of the KFTPGrabber project
 *
 * Copyright (C) 2003-2004 by the KFTPGrabber developers
 * Copyright (C) 2003-2004 Jernej Kos <kostko@jweb-network.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */

#ifndef KFTPFILEDIRVIEWACTIONS_H
#define KFTPFILEDIRVIEWACTIONS_H

#include <tqobject.h>
#include <tdeaction.h>
#include <krun.h>
#include <kservice.h>
#include <kuserprofile.h>

namespace KFTPWidgets {

namespace Browser {

class View;

/**
 * This class contains all per-view actions.
 *
 * @author Jernej Kos
 */
class Actions : public TQObject
{
TQ_OBJECT
friend class View;
friend class DetailsView;
public:
    /**
     * Class constructor.
     *
     * @param parent Parent view widget
     */
    Actions(View *parent);

    /**
     * Initialize view's action collection and it's actions.
     */
    void initActions();
    
    /**
     * Properly enable/disable the available actions.
     */
    void updateActions();
private:
    TDEActionCollection *m_actionCollection;
    View *m_view;
    
    int m_curCharsetOption;
    int m_defaultCharsetOption;
    
    TDEAction *m_goUpAction;
    TDEAction *m_goBackAction;
    TDEAction *m_goForwardAction;
    TDEAction *m_goHomeAction;
    TDEAction *m_reloadAction;
    
    TDEAction *m_abortAction;
    TDEToggleAction *m_toggleTreeViewAction;
    TDEToggleAction *m_toggleFilterAction;
    
    TDEAction *m_renameAction;
    TDEAction *m_deleteAction;
    TDEAction *m_propsAction;
    TDEAction *m_shredAction;
    
    TDEAction *m_copyAction;
    TDEAction *m_pasteAction;
    
    TDEActionMenu *m_filterActions;
    TDEAction *m_alwaysSkipAction;
    TDEAction *m_topPriorityAction;
    TDEAction *m_lowPriorityAction;

    TDEAction *m_transferAction;
    TDEAction *m_queueTransferAction;
    TDEAction *m_createDirAction;
    TDEAction *m_fileEditAction;
    TDEAction *m_verifyAction;

    TDEActionMenu *m_moreActions;
    TDEActionMenu *m_rawCommandsMenu;
    TDEAction *m_rawCmdAction;
    TDEActionMenu *m_changeEncodingAction;
    TDEAction *m_exportListingAction;
    TDEToggleAction *m_showHiddenFilesAction;
    TDEAction *m_openExternalAction;
    
    TDEAction *m_markItemsAction;
    TDEAction *m_compareAction;
    
    TDEActionMenu *m_siteChangeAction;
    TDEAction *m_quickConnectAction;
    TDEActionMenu *m_connectAction;
    TDEAction *m_disconnectAction;
private:
    /**
     * Populates the encodings list.
     */
    void populateEncodings();
    
    /**
     * A helper function to add the currently selected item(s) to the
     * priority list with the given priority.
     *
     * @param priority The priority to use
     */
    void addPriorityItems(int priority);
private slots:
    void slotGoUp();
    void slotGoBack();
    void slotGoForward();
    void slotGoHome();
    void slotReload();
    
    void slotAbort();
    void slotShowHideTree();
    void slotShowHideFilter();
    
    void slotRename();
    void slotDelete();
    void slotProps();
    void slotShred();
    
    void slotCopy();
    void slotPaste();
    
    void slotAlwaysSkip();
    void slotTopPriority();
    void slotLowPriority();

    void slotTransfer();
    void slotQueueTransfer();
    void slotCreateDir();
    void slotFileEdit();
    void slotVerify();
    
    void slotRawCmd();
    void slotCharsetChanged(int);
    void slotCharsetReset(int);
    void slotExportListing();
    void slotShowHiddenFiles();
    void slotOpenExternal();
    
    void slotMarkItems();
    void slotCompare();

    void slotQuickConnect();
    void slotDisconnect();
};

}

}

#endif
