/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 * 
 * Date        : 2005-04-21
 * Description : a tdeio-slave to process search on digiKam albums
 *
 * Copyright (C) 2005 by Renchi Raju <renchi@pooh.tam.uiuc.edu>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * ============================================================ */

#ifndef DIGIKAMSEARCH_H
#define DIGIKAMSEARCH_H

// KDE includes.

#include <tdeio/slavebase.h>

// Local includes.

#include "sqlitedb.h"

class TQStringList;

class tdeio_digikamsearch : public TDEIO::SlaveBase
{

public:

    enum SKey
    {
        ALBUM = 0,
        ALBUMNAME,
        ALBUMCAPTION,
        ALBUMCOLLECTION,
        TAG,
        TAGNAME,
        IMAGENAME,
        IMAGECAPTION,
        IMAGEDATE,
        KEYWORD,
        RATING
    };

    enum SOperator
    {
        EQ = 0,
        NE,
        LT,
        GT,
        LIKE,
        NLIKE,
        LTE,
        GTE
    };

public:

    tdeio_digikamsearch(const TQCString &pool_socket, const TQCString &app_socket);
    ~tdeio_digikamsearch();

    void special(const TQByteArray& data);

private:

    TQString buildQuery(const KURL& url) const;

    TQString subQuery(enum SKey key, enum SOperator op, const TQString& val) const;

    TQString possibleDate(const TQString& str, bool& exact) const;
    
private:

    class RuleType
    {
    public:

        SKey      key;
        SOperator op;
        TQString   val;
    };

    SqliteDB m_db;
    TQString  m_libraryPath;
    TQString  m_longMonths[12];
    TQString  m_shortMonths[12];
};

#endif /* DIGIKAMSEARCH_H */
