/***************************************************************************
 begin                : Tue Jul 30 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : chubinger@irrsinnig.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMFCHECKLISTOUTPUT_H
#define KMFCHECKLISTOUTPUT_H

#include <tqdialog.h>
#include <tqpixmap.h>
#include <tdemacros.h>
class TQLabel;
class TQListView;
class TQListViewItem;
class TQString;
class TQPushButton;
namespace KMF {
/**
  *@author Christian Hubinger
  */

class TDE_EXPORT KMFCheckListOutput : public TQDialog {
	TQ_OBJECT
  
public:
	KMFCheckListOutput( TQWidget *parent = 0, const char *name = 0, bool modal = false, WFlags fl = 0 );
	~KMFCheckListOutput();

	/**
	Appends one line at the End Of the List
	*/
	void appendLine( const TQString &txt );

	/**
	Sets the Status of the last created ListItem
	*/
	void setStatus( bool ok, const TQString &err_msg );

	void clearList();

private:

	// Functions
	void loadIcons();

	// Data
	TQListView *mlb_outputView;
	TQPushButton *mpb_ok;
	TQListViewItem *m_currItem;
	TQPixmap icon_ok;
	TQPixmap icon_err;
	TQLabel *text;
};
}
#endif
