// File autogenerated

// declaration include
#include "filechooserInterface.h"

// TQt includes
#include <tqdom.h>
#include <tqmap.h>
#include <tqstring.h>

// TQt D-Bus includes
#include <tqdbusdata.h>
#include <tqdbusdatamap.h>
#include <tqdbuserror.h>
#include <tqdbusmessage.h>
#include <tqdbusobjectpath.h>
#include <tqdbusvariant.h>


namespace org
{
namespace freedesktop
{
namespace impl
{
namespace portal
{

void FileChooserInterface::buildIntrospectionData(TQDomElement& interfaceElement)
{
    interfaceElement.setAttribute("name", "org.freedesktop.impl.portal.FileChooser");

    TQDomDocument document = interfaceElement.ownerDocument();
    TQDomElement methodElement = document.createElement("method");
    TQDomElement asyncAnnotationElement = document.createElement("annotation");
    asyncAnnotationElement.setAttribute("name", "org.freedesktop.DBus.GLib.Async");
    asyncAnnotationElement.setAttribute("value", "true");
    methodElement.appendChild(asyncAnnotationElement);
    methodElement.setAttribute("name", "OpenFile");

    TQDomElement argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "handle");
    argumentElement.setAttribute("type",      "o");
    argumentElement.setAttribute("direction", "in");
    methodElement.appendChild(argumentElement);

    argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "app_id");
    argumentElement.setAttribute("type",      "s");
    argumentElement.setAttribute("direction", "in");
    methodElement.appendChild(argumentElement);

    argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "parent_window");
    argumentElement.setAttribute("type",      "s");
    argumentElement.setAttribute("direction", "in");
    methodElement.appendChild(argumentElement);

    argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "title");
    argumentElement.setAttribute("type",      "s");
    argumentElement.setAttribute("direction", "in");
    methodElement.appendChild(argumentElement);

    argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "options");
    argumentElement.setAttribute("type",      "a{sv}");
    argumentElement.setAttribute("direction", "in");
    methodElement.appendChild(argumentElement);

    argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "response");
    argumentElement.setAttribute("type",      "u");
    argumentElement.setAttribute("direction", "out");
    methodElement.appendChild(argumentElement);

    argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "results");
    argumentElement.setAttribute("type",      "a{sv}");
    argumentElement.setAttribute("direction", "out");
    methodElement.appendChild(argumentElement);

    interfaceElement.appendChild(methodElement);

    methodElement = document.createElement("method");
    asyncAnnotationElement = document.createElement("annotation");
    asyncAnnotationElement.setAttribute("name", "org.freedesktop.DBus.GLib.Async");
    asyncAnnotationElement.setAttribute("value", "true");
    methodElement.appendChild(asyncAnnotationElement);
    methodElement.setAttribute("name", "SaveFile");

    argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "handle");
    argumentElement.setAttribute("type",      "o");
    argumentElement.setAttribute("direction", "in");
    methodElement.appendChild(argumentElement);

    argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "app_id");
    argumentElement.setAttribute("type",      "s");
    argumentElement.setAttribute("direction", "in");
    methodElement.appendChild(argumentElement);

    argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "parent_window");
    argumentElement.setAttribute("type",      "s");
    argumentElement.setAttribute("direction", "in");
    methodElement.appendChild(argumentElement);

    argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "title");
    argumentElement.setAttribute("type",      "s");
    argumentElement.setAttribute("direction", "in");
    methodElement.appendChild(argumentElement);

    argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "options");
    argumentElement.setAttribute("type",      "a{sv}");
    argumentElement.setAttribute("direction", "in");
    methodElement.appendChild(argumentElement);

    argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "response");
    argumentElement.setAttribute("type",      "u");
    argumentElement.setAttribute("direction", "out");
    methodElement.appendChild(argumentElement);

    argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "results");
    argumentElement.setAttribute("type",      "a{sv}");
    argumentElement.setAttribute("direction", "out");
    methodElement.appendChild(argumentElement);

    interfaceElement.appendChild(methodElement);

    methodElement = document.createElement("method");
    asyncAnnotationElement = document.createElement("annotation");
    asyncAnnotationElement.setAttribute("name", "org.freedesktop.DBus.GLib.Async");
    asyncAnnotationElement.setAttribute("value", "true");
    methodElement.appendChild(asyncAnnotationElement);
    methodElement.setAttribute("name", "SaveFiles");

    argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "handle");
    argumentElement.setAttribute("type",      "o");
    argumentElement.setAttribute("direction", "in");
    methodElement.appendChild(argumentElement);

    argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "app_id");
    argumentElement.setAttribute("type",      "s");
    argumentElement.setAttribute("direction", "in");
    methodElement.appendChild(argumentElement);

    argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "parent_window");
    argumentElement.setAttribute("type",      "s");
    argumentElement.setAttribute("direction", "in");
    methodElement.appendChild(argumentElement);

    argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "title");
    argumentElement.setAttribute("type",      "s");
    argumentElement.setAttribute("direction", "in");
    methodElement.appendChild(argumentElement);

    argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "options");
    argumentElement.setAttribute("type",      "a{sv}");
    argumentElement.setAttribute("direction", "in");
    methodElement.appendChild(argumentElement);

    argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "response");
    argumentElement.setAttribute("type",      "u");
    argumentElement.setAttribute("direction", "out");
    methodElement.appendChild(argumentElement);

    argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "results");
    argumentElement.setAttribute("type",      "a{sv}");
    argumentElement.setAttribute("direction", "out");
    methodElement.appendChild(argumentElement);

    interfaceElement.appendChild(methodElement);
}

void FileChooserInterface::OpenFileAsyncReply(int asyncCallId, TQ_UINT32 response, const TQMap< TQString, TQT_DBusVariant >& results)

{
    TQMap<int, TQT_DBusMessage>::iterator findIt = m_asyncCalls.find(asyncCallId);
    if (findIt == m_asyncCalls.end()) return;

    TQT_DBusMessage call = findIt.data();
    m_asyncCalls.erase(findIt);

    TQT_DBusMessage reply = TQT_DBusMessage::methodReply(call);
    reply << TQT_DBusData::fromUInt32(response);
    reply << TQT_DBusData::fromStringKeyMap(TQT_DBusDataMap< TQString >(results));

    handleMethodReply(reply);
}

void FileChooserInterface::OpenFileAsyncError(int asyncCallId, const TQT_DBusError& error)
{
    TQMap<int, TQT_DBusMessage>::iterator findIt = m_asyncCalls.find(asyncCallId);
    if (findIt == m_asyncCalls.end()) return;

    TQT_DBusMessage call = findIt.data();
    m_asyncCalls.erase(findIt);

    TQT_DBusMessage reply = TQT_DBusMessage::methodError(call, error);
    handleMethodReply(reply);
}

void FileChooserInterface::SaveFileAsyncReply(int asyncCallId, TQ_UINT32 response, const TQMap< TQString, TQT_DBusVariant >& results)

{
    TQMap<int, TQT_DBusMessage>::iterator findIt = m_asyncCalls.find(asyncCallId);
    if (findIt == m_asyncCalls.end()) return;

    TQT_DBusMessage call = findIt.data();
    m_asyncCalls.erase(findIt);

    TQT_DBusMessage reply = TQT_DBusMessage::methodReply(call);
    reply << TQT_DBusData::fromUInt32(response);
    reply << TQT_DBusData::fromStringKeyMap(TQT_DBusDataMap< TQString >(results));

    handleMethodReply(reply);
}

void FileChooserInterface::SaveFileAsyncError(int asyncCallId, const TQT_DBusError& error)
{
    TQMap<int, TQT_DBusMessage>::iterator findIt = m_asyncCalls.find(asyncCallId);
    if (findIt == m_asyncCalls.end()) return;

    TQT_DBusMessage call = findIt.data();
    m_asyncCalls.erase(findIt);

    TQT_DBusMessage reply = TQT_DBusMessage::methodError(call, error);
    handleMethodReply(reply);
}

void FileChooserInterface::SaveFilesAsyncReply(int asyncCallId, TQ_UINT32 response, const TQMap< TQString, TQT_DBusVariant >& results)

{
    TQMap<int, TQT_DBusMessage>::iterator findIt = m_asyncCalls.find(asyncCallId);
    if (findIt == m_asyncCalls.end()) return;

    TQT_DBusMessage call = findIt.data();
    m_asyncCalls.erase(findIt);

    TQT_DBusMessage reply = TQT_DBusMessage::methodReply(call);
    reply << TQT_DBusData::fromUInt32(response);
    reply << TQT_DBusData::fromStringKeyMap(TQT_DBusDataMap< TQString >(results));

    handleMethodReply(reply);
}

void FileChooserInterface::SaveFilesAsyncError(int asyncCallId, const TQT_DBusError& error)
{
    TQMap<int, TQT_DBusMessage>::iterator findIt = m_asyncCalls.find(asyncCallId);
    if (findIt == m_asyncCalls.end()) return;

    TQT_DBusMessage call = findIt.data();
    m_asyncCalls.erase(findIt);

    TQT_DBusMessage reply = TQT_DBusMessage::methodError(call, error);
    handleMethodReply(reply);
}

void FileChooserInterface::callOpenFileAsync(const TQT_DBusMessage& message)
{
    TQT_DBusObjectPath _handle = message[0].toObjectPath();
    TQString _app_id = message[1].toString();
    TQString _parent_window = message[2].toString();
    TQString _title = message[3].toString();
    TQMap< TQString, TQT_DBusVariant > _options = message[4].toStringKeyMap().toVariantMap();

    int _asyncCallId = 0;
    while (m_asyncCalls.find(_asyncCallId) != m_asyncCalls.end())
    {
        ++_asyncCallId;
    }
    m_asyncCalls.insert(_asyncCallId, message);

    OpenFileAsync(_asyncCallId, _handle, _app_id, _parent_window, _title, _options);

    return;
}

void FileChooserInterface::callSaveFileAsync(const TQT_DBusMessage& message)
{
    TQT_DBusObjectPath _handle = message[0].toObjectPath();
    TQString _app_id = message[1].toString();
    TQString _parent_window = message[2].toString();
    TQString _title = message[3].toString();
    TQMap< TQString, TQT_DBusVariant > _options = message[4].toStringKeyMap().toVariantMap();

    int _asyncCallId = 0;
    while (m_asyncCalls.find(_asyncCallId) != m_asyncCalls.end())
    {
        ++_asyncCallId;
    }
    m_asyncCalls.insert(_asyncCallId, message);

    SaveFileAsync(_asyncCallId, _handle, _app_id, _parent_window, _title, _options);

    return;
}

void FileChooserInterface::callSaveFilesAsync(const TQT_DBusMessage& message)
{
    TQT_DBusObjectPath _handle = message[0].toObjectPath();
    TQString _app_id = message[1].toString();
    TQString _parent_window = message[2].toString();
    TQString _title = message[3].toString();
    TQMap< TQString, TQT_DBusVariant > _options = message[4].toStringKeyMap().toVariantMap();

    int _asyncCallId = 0;
    while (m_asyncCalls.find(_asyncCallId) != m_asyncCalls.end())
    {
        ++_asyncCallId;
    }
    m_asyncCalls.insert(_asyncCallId, message);

    SaveFilesAsync(_asyncCallId, _handle, _app_id, _parent_window, _title, _options);

    return;
}

bool FileChooserInterface::handleMethodCall(const TQT_DBusMessage& message)
{
    if (message.interface() != "org.freedesktop.impl.portal.FileChooser") return false;

    if (message.member() == "OpenFile")
    {
        callOpenFileAsync(message);

        return true;
    }

    if (message.member() == "SaveFile")
    {
        callSaveFileAsync(message);

        return true;
    }

    if (message.member() == "SaveFiles")
    {
        callSaveFilesAsync(message);

        return true;
    }

    return false; 
}

}; // namespace portal

}; // namespace impl

}; // namespace freedesktop

}; // namespace org

// End of File

