// File autogenerated

// declaration include
#include "wifiproxy.h"

// TQt includes
#include <tqmap.h>
#include <tqstring.h>
#include <tqvaluelist.h>

// TQt D-Bus includes
#include <tqdbusconnection.h>
#include <tqdbusdata.h>
#include <tqdbusdatalist.h>
#include <tqdbusdatamap.h>
#include <tqdbuserror.h>
#include <tqdbusmessage.h>
#include <tqdbusobjectpath.h>
#include <tqdbusproxy.h>
#include <tqdbusvariant.h>


namespace DBus
{

WiFiDeviceProxy::WiFiDeviceProxy(const TQString& service, const TQString& path, TQObject* parent, const char* name)
    : TQObject(parent, name),
      m_baseProxy(new TQT_DBusProxy())
{
    m_baseProxy->setInterface("org.freedesktop.NetworkManager.Device.Wireless");
    m_baseProxy->setPath(path);
    m_baseProxy->setService(service);

    TQObject::connect(m_baseProxy, TQ_SIGNAL(dbusSignal(const TQT_DBusMessage&)),
                     this,        TQ_SLOT(slotHandleDBusSignal(const TQT_DBusMessage&)));
    TQObject::connect(m_baseProxy, TQ_SIGNAL(asyncReply(int, const TQT_DBusMessage&)),
                     this,        TQ_SLOT(slotHandleAsyncReply(int, const TQT_DBusMessage&)));
}

WiFiDeviceProxy::~WiFiDeviceProxy()
{
    delete m_baseProxy;
}

void WiFiDeviceProxy::setConnection(const TQT_DBusConnection& connection)
{
    m_baseProxy->setConnection(connection);
}

bool WiFiDeviceProxy::GetAccessPoints(TQValueList< TQT_DBusObjectPath >& access_points, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;


    TQT_DBusMessage reply = m_baseProxy->sendWithReply("GetAccessPoints", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;

    if (reply.count() != 1) return false;

    bool ok = false;

    bool subOK = false;

    access_points = reply.front().toList(&ok).toObjectPathList(&subOK);
    if (!subOK) return false;
    if (!ok) return false;

    return true;
}

bool WiFiDeviceProxy::RequestScanAsync(int& asyncCallId, const TQMap< TQString, TQT_DBusVariant >& options, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromStringKeyMap(TQT_DBusDataMap< TQString >(options));

    asyncCallId = m_baseProxy->sendWithAsyncReply("RequestScan", parameters);

    if (asyncCallId != 0) m_asyncCalls[asyncCallId] = "RequestScan";

    error = TQT_DBusError();
    return (asyncCallId != 0);
}

void WiFiDeviceProxy::setDBusProperty(const TQString& name, const TQT_DBusVariant& value, TQT_DBusError& error)
{
    TQT_DBusConnection connection = m_baseProxy->connection();

    TQT_DBusMessage message = TQT_DBusMessage::methodCall(m_baseProxy->service(), m_baseProxy->path(), "org.freedesktop.DBus.Properties", "Set");

    message << TQT_DBusData::fromString(m_baseProxy->interface());
    message << TQT_DBusData::fromString(name);
    message << TQT_DBusData::fromVariant(value);

    connection.sendWithReply(message, &error);
}

TQT_DBusVariant WiFiDeviceProxy::getDBusProperty(const TQString& name, TQT_DBusError& error) const
{
    TQT_DBusConnection connection = m_baseProxy->connection();

    TQT_DBusMessage message = TQT_DBusMessage::methodCall(m_baseProxy->service(), m_baseProxy->path(), "org.freedesktop.DBus.Properties", "Get");

    message << TQT_DBusData::fromString(m_baseProxy->interface());
    message << TQT_DBusData::fromString(name);

    TQT_DBusMessage reply = connection.sendWithReply(message, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return TQT_DBusVariant();
    if (reply.count() != 1) return TQT_DBusVariant();

    bool ok = false;
    TQT_DBusVariant value = reply.front().toVariant(&ok);
    if (!ok) return TQT_DBusVariant();

    return value;
}

TQString WiFiDeviceProxy::getHwAddress(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("HwAddress", error);

    if (error.isValid()) return TQString();

    bool ok = false;

    TQString result =  variant.value.toString(&ok);
    if (!ok) {}

    return result;
}

TQString WiFiDeviceProxy::getPermHwAddress(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("PermHwAddress", error);

    if (error.isValid()) return TQString();

    bool ok = false;

    TQString result =  variant.value.toString(&ok);
    if (!ok) {}

    return result;
}

TQ_UINT32 WiFiDeviceProxy::getMode(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Mode", error);

    if (error.isValid()) return TQ_UINT32();

    bool ok = false;

    TQ_UINT32 result =  variant.value.toUInt32(&ok);
    if (!ok) {}

    return result;
}

TQ_UINT32 WiFiDeviceProxy::getBitrate(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Bitrate", error);

    if (error.isValid()) return TQ_UINT32();

    bool ok = false;

    TQ_UINT32 result =  variant.value.toUInt32(&ok);
    if (!ok) {}

    return result;
}

TQT_DBusObjectPath WiFiDeviceProxy::getActiveAccessPoint(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("ActiveAccessPoint", error);

    if (error.isValid()) return TQT_DBusObjectPath();

    bool ok = false;

    TQT_DBusObjectPath result =  variant.value.toObjectPath(&ok);
    if (!ok) {}

    return result;
}

TQ_UINT32 WiFiDeviceProxy::getWirelessCapabilities(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("WirelessCapabilities", error);

    if (error.isValid()) return TQ_UINT32();

    bool ok = false;

    TQ_UINT32 result =  variant.value.toUInt32(&ok);
    if (!ok) {}

    return result;
}

void WiFiDeviceProxy::slotHandleDBusSignal(const TQT_DBusMessage& message)
{
    if (message.member() == "PropertiesChanged")
    {
        TQMap< TQString, TQT_DBusVariant > _properties = message[0].toStringKeyMap().toVariantMap();

        emit PropertiesChanged(_properties);
    }
    else if (message.member() == "AccessPointAdded")
    {
        TQT_DBusObjectPath _access_point = message[0].toObjectPath();

        emit AccessPointAdded(_access_point);
    }
    else if (message.member() == "AccessPointRemoved")
    {
        TQT_DBusObjectPath _access_point = message[0].toObjectPath();

        emit AccessPointRemoved(_access_point);
    }
}

void WiFiDeviceProxy::slotHandleAsyncReply(int asyncCallId, const TQT_DBusMessage& message)
{
    TQMap<int, TQString>::iterator findIt = m_asyncCalls.find(asyncCallId);
    if (findIt == m_asyncCalls.end()) return;

    const TQString signalName = findIt.data();
    m_asyncCalls.erase(findIt);

    if (signalName == "RequestScan")
    {
        int _asyncCallId = asyncCallId;

        if (message.type() == TQT_DBusMessage::ErrorMessage) {
            emit AsyncErrorResponseDetected(_asyncCallId, message.error());
        }


        emit RequestScanAsyncReply(_asyncCallId);
    }
}

}; // namespace DBus

#include "wifiproxy.moc"

// End of File

