/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.pool2.impl;

import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.tomcat.dbcp.pool2.impl.BaseGenericObjectPool;

final class EvictionTimer {
    private static ScheduledThreadPoolExecutor executor;
    private static final HashMap<WeakReference<BaseGenericObjectPool.Evictor>, WeakRunner<BaseGenericObjectPool.Evictor>> TASK_MAP;

    static synchronized void cancel(BaseGenericObjectPool.Evictor evictor, Duration duration, boolean bl) {
        if (evictor != null) {
            evictor.cancel();
            EvictionTimer.remove(evictor);
        }
        if (!bl && executor != null && TASK_MAP.isEmpty()) {
            executor.shutdown();
            try {
                executor.awaitTermination(duration.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            executor.setCorePoolSize(0);
            executor = null;
        }
    }

    static synchronized int getNumTasks() {
        return TASK_MAP.size();
    }

    static HashMap<WeakReference<BaseGenericObjectPool.Evictor>, WeakRunner<BaseGenericObjectPool.Evictor>> getTaskMap() {
        return TASK_MAP;
    }

    private static void remove(BaseGenericObjectPool.Evictor evictor) {
        for (Map.Entry<WeakReference<BaseGenericObjectPool.Evictor>, WeakRunner<BaseGenericObjectPool.Evictor>> entry : TASK_MAP.entrySet()) {
            if (entry.getKey().get() != evictor) continue;
            executor.remove(entry.getValue());
            TASK_MAP.remove(entry.getKey());
            break;
        }
    }

    static synchronized void schedule(BaseGenericObjectPool.Evictor evictor, Duration duration, Duration duration2) {
        if (null == executor) {
            executor = new ScheduledThreadPoolExecutor(1, new EvictorThreadFactory());
            executor.setRemoveOnCancelPolicy(true);
            executor.scheduleAtFixedRate(new Reaper(), duration.toMillis(), duration2.toMillis(), TimeUnit.MILLISECONDS);
        }
        WeakReference<BaseGenericObjectPool.Evictor> weakReference = new WeakReference<BaseGenericObjectPool.Evictor>(evictor);
        WeakRunner<BaseGenericObjectPool.Evictor> weakRunner = new WeakRunner<BaseGenericObjectPool.Evictor>(weakReference);
        ScheduledFuture<?> scheduledFuture = executor.scheduleWithFixedDelay(weakRunner, duration.toMillis(), duration2.toMillis(), TimeUnit.MILLISECONDS);
        evictor.setScheduledFuture(scheduledFuture);
        TASK_MAP.put(weakReference, weakRunner);
    }

    private EvictionTimer() {
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("EvictionTimer []");
        return stringBuilder.toString();
    }

    static {
        TASK_MAP = new HashMap();
    }

    private static final class EvictorThreadFactory
    implements ThreadFactory {
        private EvictorThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(null, runnable, "commons-pool-evictor");
            thread.setDaemon(true);
            AccessController.doPrivileged(() -> {
                thread.setContextClassLoader(EvictorThreadFactory.class.getClassLoader());
                return null;
            });
            return thread;
        }
    }

    private static final class Reaper
    implements Runnable {
        private Reaper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Class<EvictionTimer> clazz = EvictionTimer.class;
            synchronized (EvictionTimer.class) {
                for (Map.Entry<WeakReference<BaseGenericObjectPool.Evictor>, WeakRunner<BaseGenericObjectPool.Evictor>> entry : TASK_MAP.entrySet()) {
                    if (entry.getKey().get() != null) continue;
                    executor.remove(entry.getValue());
                    TASK_MAP.remove(entry.getKey());
                }
                if (TASK_MAP.isEmpty() && executor != null) {
                    executor.shutdown();
                    executor.setCorePoolSize(0);
                    executor = null;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }

    private static final class WeakRunner<R extends Runnable>
    implements Runnable {
        private final WeakReference<R> ref;

        private WeakRunner(WeakReference<R> weakReference) {
            this.ref = weakReference;
        }

        @Override
        public void run() {
            Runnable runnable = (Runnable)this.ref.get();
            if (runnable != null) {
                runnable.run();
            } else {
                executor.remove(this);
                TASK_MAP.remove(this.ref);
            }
        }
    }
}

