/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.swing.SwingTools;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JViewport;

public class ScaledImageComponent
extends JComponent {
    private static final int MODEL_PREFERRED_SIZE = Math.round(300.0f * SwingTools.getResolutionScale());
    private BufferedImage image;
    private boolean imageEnlargementEnabled;
    private float scaleMultiplier = 1.0f;

    public ScaledImageComponent() {
        this(null);
    }

    public ScaledImageComponent(BufferedImage bufferedImage) {
        this(bufferedImage, false);
    }

    public ScaledImageComponent(BufferedImage bufferedImage, boolean bl) {
        this.image = bufferedImage;
        this.imageEnlargementEnabled = bl;
        this.setBorder(BorderFactory.createEtchedBorder(1));
    }

    @Override
    public Dimension getPreferredSize() {
        float f;
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Insets insets = this.getInsets();
        int n = MODEL_PREFERRED_SIZE;
        int n2 = MODEL_PREFERRED_SIZE;
        int n3 = insets.left + insets.right;
        int n4 = insets.top + insets.bottom;
        if (this.image == null) {
            return new Dimension(n + n3, n2 + n4);
        }
        if (this.getParent() instanceof JViewport) {
            float f2;
            Dimension dimension = ((JViewport)this.getParent()).getExtentSize();
            dimension.width -= n3;
            dimension.height -= n4;
            float f3 = (float)this.image.getWidth() / (float)dimension.width;
            if (f3 > (f2 = (float)this.image.getHeight() / (float)dimension.height)) {
                return new Dimension((int)((float)dimension.width * this.scaleMultiplier) + n3, (int)((float)this.image.getHeight() / f3 * this.scaleMultiplier) + n4);
            }
            return new Dimension((int)((float)this.image.getWidth() / f2 * this.scaleMultiplier) + n3, (int)((float)dimension.height * this.scaleMultiplier) + n4);
        }
        int n5 = n - n3;
        int n6 = n2 - n4;
        float f4 = (float)this.image.getWidth() / (float)n5;
        if (f4 > (f = (float)this.image.getHeight() / (float)n6)) {
            return new Dimension((int)((float)n5 * this.scaleMultiplier) + n3, (int)((float)this.image.getHeight() / f4 * this.scaleMultiplier) + n4);
        }
        return new Dimension((int)((float)this.image.getWidth() / f * this.scaleMultiplier) + n3, (int)((float)n6 * this.scaleMultiplier) + n4);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        this.paintImage(graphics, null);
    }

    protected void paintImage(Graphics graphics, AlphaComposite alphaComposite) {
        if (this.image != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            AffineTransform affineTransform = graphics2D.getTransform();
            Composite composite = graphics2D.getComposite();
            Point point = this.getImageTranslation();
            graphics2D.translate(point.x, point.y);
            float f = this.getImageScale();
            graphics2D.scale(f, f);
            if (alphaComposite != null) {
                graphics2D.setComposite(alphaComposite);
            }
            graphics2D.drawImage((Image)this.image, 0, 0, this);
            graphics2D.setComposite(composite);
            graphics2D.setTransform(affineTransform);
        }
    }

    public void setImage(BufferedImage bufferedImage) {
        this.image = bufferedImage;
        this.revalidate();
        this.repaint();
    }

    public BufferedImage getImage() {
        return this.image;
    }

    protected float getImageScale() {
        float f;
        if (this.image != null) {
            Dimension dimension = this.getParent() instanceof JViewport ? ((JViewport)this.getParent()).getExtentSize() : this.getSize();
            Insets insets = this.getInsets();
            f = Math.min((float)(dimension.width - insets.left - insets.right) / (float)this.image.getWidth(), (float)(dimension.height - insets.top - insets.bottom) / (float)this.image.getHeight());
            if (!this.imageEnlargementEnabled) {
                f = Math.min(1.0f, f);
            }
        } else {
            f = 1.0f;
        }
        return f * this.scaleMultiplier;
    }

    public float getScaleMultiplier() {
        return this.scaleMultiplier;
    }

    public void setScaleMultiplier(float f) {
        this.scaleMultiplier = f;
        this.revalidate();
        this.repaint();
    }

    protected Point getImageTranslation() {
        float f = this.getImageScale();
        Insets insets = this.getInsets();
        return new Point(insets.left + (this.getWidth() - insets.left - insets.right - Math.round((float)this.image.getWidth() * f)) / 2, insets.top + (this.getHeight() - insets.top - insets.bottom - Math.round((float)this.image.getHeight() * f)) / 2);
    }

    protected boolean isPointInImage(int n, int n2) {
        Point point = this.getImageTranslation();
        float f = this.getImageScale();
        return n >= point.x && n < point.x + Math.round((float)this.getImage().getWidth() * f) && n2 >= point.y && n2 < point.y + Math.round((float)this.getImage().getHeight() * f);
    }

    protected Point getPointConstrainedInImage(int n, int n2) {
        Point point = this.getImageTranslation();
        float f = this.getImageScale();
        n = Math.min(Math.max(n, point.x), point.x + Math.round((float)this.getImage().getWidth() * f));
        n2 = Math.min(Math.max(n2, point.y), point.y + Math.round((float)this.getImage().getHeight() * f));
        return new Point(n, n2);
    }
}

