/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.ui.shapes;

import com.jogamp.common.av.AudioSink;
import com.jogamp.common.util.InterruptSource;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.ui.shapes.TexSeqButton;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.util.av.GLMediaPlayer;
import com.jogamp.opengl.util.texture.TextureSequence;

public class MediaButton
extends TexSeqButton {
    private boolean verbose = false;
    private final GLMediaPlayer.GLMediaEventListener defGLMediaEventListener = new GLMediaPlayer.GLMediaEventListener(){

        @Override
        public void newFrameAvailable(GLMediaPlayer gLMediaPlayer, TextureSequence.TextureFrame textureFrame, long l) {
        }

        @Override
        public void attributesChanged(final GLMediaPlayer gLMediaPlayer, GLMediaPlayer.EventMask eventMask, long l) {
            GLMediaPlayer.StreamException streamException;
            if (MediaButton.this.verbose) {
                System.err.println("MediaButton AttributesChanges: " + eventMask + ", when " + l);
                System.err.println("MediaButton State: " + gLMediaPlayer);
            }
            if (eventMask.isSet(GLMediaPlayer.EventMask.Bit.Init)) {
                MediaButton.this.resetGL = true;
            }
            if (eventMask.isSet(GLMediaPlayer.EventMask.Bit.Size)) {
                // empty if block
            }
            if (eventMask.isSet(GLMediaPlayer.EventMask.Bit.EOS)) {
                new InterruptSource.Thread(){

                    public void run() {
                        gLMediaPlayer.seek(0);
                        gLMediaPlayer.resume();
                    }
                }.start();
            } else if (eventMask.isSet(GLMediaPlayer.EventMask.Bit.Error) && null != (streamException = gLMediaPlayer.getStreamException())) {
                streamException.printStackTrace();
            }
        }
    };
    volatile boolean resetGL = true;

    public MediaButton(int n, float f, float f2, GLMediaPlayer gLMediaPlayer) {
        super(n, f, f2, gLMediaPlayer);
        this.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.setPressedColorMod(0.9f, 0.9f, 0.9f, 0.7f);
        this.setToggleOffColorMod(0.8f, 0.8f, 0.8f, 1.0f);
        this.setToggleOnColorMod(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void addDefaultEventListener() {
        this.getGLMediaPlayer().addEventListener(this.defGLMediaEventListener);
    }

    public final GLMediaPlayer getGLMediaPlayer() {
        return (GLMediaPlayer)this.texSeq;
    }

    public final AudioSink getAudioSink() {
        return this.getGLMediaPlayer().getAudioSink();
    }

    @Override
    protected void destroyImpl(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
        ((GLMediaPlayer)this.texSeq).destroy(gL2ES2);
    }

    @Override
    public void draw(GL2ES2 gL2ES2, RegionRenderer regionRenderer, int[] nArray) {
        GLMediaPlayer gLMediaPlayer = (GLMediaPlayer)this.texSeq;
        if (this.resetGL) {
            this.resetGL = false;
            try {
                gLMediaPlayer.initGL(gL2ES2);
                if (null != this.region) {
                    this.region.markShapeDirty();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        super.draw(gL2ES2, regionRenderer, nArray);
        this.markStateDirty();
    }
}

