/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.ui;

import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.ui.Container;
import com.jogamp.graph.ui.Shape;
import com.jogamp.graph.ui.layout.Padding;
import com.jogamp.graph.ui.shapes.Rectangle;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.math.Vec3f;
import com.jogamp.opengl.math.Vec4f;
import com.jogamp.opengl.math.geom.AABBox;
import com.jogamp.opengl.util.PMVMatrix;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import jogamp.graph.ui.TreeTool;

public class Group
extends Shape
implements Container {
    private final List<Shape> shapes = new ArrayList<Shape>();
    private Layout layouter;
    private Rectangle border = null;
    private boolean doFrustumCulling = false;

    public Group() {
        this(null);
    }

    public Group(Layout layout) {
        this.layouter = layout;
        this.setInteractive(false);
    }

    public Layout getLayout() {
        return this.layouter;
    }

    public Group setLayout(Layout layout) {
        this.layouter = layout;
        return this;
    }

    @Override
    public List<Shape> getShapes() {
        return this.shapes;
    }

    @Override
    public void addShape(Shape shape) {
        this.shapes.add(shape);
        this.markShapeDirty();
    }

    @Override
    public Shape removeShape(Shape shape) {
        Shape shape2 = this.shapes.remove(shape) ? shape : null;
        this.markShapeDirty();
        return shape2;
    }

    @Override
    public Shape removeShape(int n) {
        Shape shape = this.shapes.remove(n);
        this.markShapeDirty();
        return shape;
    }

    public void removeShape(GL2ES2 gL2ES2, RegionRenderer regionRenderer, Shape shape) {
        this.shapes.remove(shape);
        shape.destroy(gL2ES2, regionRenderer);
    }

    @Override
    public void addShapes(Collection<? extends Shape> collection) {
        for (Shape shape : collection) {
            this.addShape(shape);
        }
    }

    @Override
    public void removeShapes(Collection<? extends Shape> collection) {
        for (Shape shape : collection) {
            this.removeShape(shape);
        }
    }

    public void removeShapes(GL2ES2 gL2ES2, RegionRenderer regionRenderer, Collection<? extends Shape> collection) {
        for (Shape shape : collection) {
            this.removeShape(gL2ES2, regionRenderer, shape);
        }
    }

    @Override
    public void removeAllShapes() {
        this.shapes.clear();
    }

    public void removeAllShapes(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
        int n = this.shapes.size();
        for (int i = n - 1; i >= 0; --i) {
            this.removeShape(gL2ES2, regionRenderer, this.shapes.get(i));
        }
    }

    @Override
    public boolean hasColorChannel() {
        return false;
    }

    @Override
    protected final void clearImpl0(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
        for (Shape shape : this.shapes) {
            shape.clear(gL2ES2, regionRenderer);
        }
    }

    @Override
    protected final void destroyImpl0(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
        for (Shape shape : this.shapes) {
            shape.destroy(gL2ES2, regionRenderer);
        }
        if (null != this.border) {
            this.border.destroy(gL2ES2, regionRenderer);
            this.border = null;
        }
    }

    @Override
    public final void setFrustumCullingEnabled(boolean bl) {
        this.doFrustumCulling = bl;
    }

    @Override
    public final boolean isFrustumCullingEnabled() {
        return this.doFrustumCulling;
    }

    @Override
    protected final void drawImpl0(GL2ES2 gL2ES2, RegionRenderer regionRenderer, int[] nArray, Vec4f vec4f) {
        PMVMatrix pMVMatrix = regionRenderer.getMatrix();
        Object[] objectArray = this.shapes.toArray();
        Arrays.sort(objectArray, Shape.ZAscendingComparator);
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Shape shape = (Shape)objectArray[i];
            if (!shape.isEnabled()) continue;
            pMVMatrix.glPushMatrix();
            shape.setTransform(pMVMatrix);
            if (!this.doFrustumCulling || !pMVMatrix.getFrustum().isAABBoxOutside(shape.getBounds())) {
                if (null == vec4f) {
                    shape.drawToSelect(gL2ES2, regionRenderer, nArray);
                } else {
                    shape.draw(gL2ES2, regionRenderer, nArray);
                }
            }
            pMVMatrix.glPopMatrix();
        }
        if (null != this.border) {
            if (null == vec4f) {
                this.border.drawToSelect(gL2ES2, regionRenderer, nArray);
            } else {
                this.border.draw(gL2ES2, regionRenderer, nArray);
            }
        }
    }

    @Override
    protected void validateImpl(GLProfile gLProfile, GL2ES2 gL2ES2) {
        if (this.isShapeDirty()) {
            Object object;
            PMVMatrix pMVMatrix = new PMVMatrix();
            if (null != this.layouter) {
                for (Shape object2 : this.shapes) {
                    if (null != gL2ES2) {
                        object2.validate(gL2ES2);
                        continue;
                    }
                    object2.validate(gLProfile);
                }
                this.layouter.layout(this, this.box, pMVMatrix);
            } else {
                object = new AABBox();
                for (Shape shape : this.shapes) {
                    if (null != gL2ES2) {
                        shape.validate(gL2ES2);
                    } else {
                        shape.validate(gLProfile);
                    }
                    pMVMatrix.glPushMatrix();
                    shape.setTransform(pMVMatrix);
                    shape.getBounds().transformMv(pMVMatrix, (AABBox)object);
                    pMVMatrix.glPopMatrix();
                    this.box.resize((AABBox)object);
                }
            }
            if (this.hasPadding()) {
                object = this.getPadding();
                Vec3f vec3f = this.box.getLow();
                Vec3f vec3f2 = this.box.getHigh();
                this.box.resize(vec3f.x() - ((Padding)object).left, vec3f.y() - ((Padding)object).bottom, vec3f.z());
                this.box.resize(vec3f2.x() + ((Padding)object).right, vec3f2.y() + ((Padding)object).top, vec3f.z());
                this.setRotationPivot(this.box.getCenter());
            }
            if (this.hasBorder()) {
                if (null == this.border) {
                    this.border = new Rectangle(2, this.box, this.getBorderThickness());
                } else {
                    this.border.setEnabled(true);
                    this.border.setBounds(this.box, this.getBorderThickness());
                }
                this.border.setColor(this.getBorderColor());
            } else if (null != this.border) {
                this.border.setEnabled(false);
            }
        }
    }

    @Override
    public boolean contains(Shape shape) {
        if (this.shapes.contains(shape)) {
            return true;
        }
        for (Shape shape2 : this.shapes) {
            if (!(shape2 instanceof Container) || !((Container)((Object)shape2)).contains(shape)) continue;
            return true;
        }
        return false;
    }

    @Override
    public AABBox getBounds(PMVMatrix pMVMatrix, Shape shape) {
        pMVMatrix.reset();
        this.setTransform(pMVMatrix);
        AABBox aABBox = new AABBox();
        if (null == shape) {
            return aABBox;
        }
        this.forOne(pMVMatrix, shape, () -> shape.getBounds().transformMv(pMVMatrix, aABBox));
        return aABBox;
    }

    @Override
    public String getSubString() {
        return super.getSubString() + ", shapes " + this.shapes.size();
    }

    @Override
    public boolean forOne(PMVMatrix pMVMatrix, Shape shape, Runnable runnable) {
        return TreeTool.forOne(this.shapes, pMVMatrix, shape, runnable);
    }

    @Override
    public boolean forAll(Shape.Visitor1 visitor1) {
        return TreeTool.forAll(this.shapes, visitor1);
    }

    @Override
    public boolean forAll(PMVMatrix pMVMatrix, Shape.Visitor2 visitor2) {
        return TreeTool.forAll(this.shapes, pMVMatrix, visitor2);
    }

    @Override
    public boolean forSortedAll(Comparator<Shape> comparator, PMVMatrix pMVMatrix, Shape.Visitor2 visitor2) {
        return TreeTool.forSortedAll(comparator, this.shapes, pMVMatrix, visitor2);
    }

    public static interface Layout {
        public void layout(Group var1, AABBox var2, PMVMatrix var3);
    }
}

